/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.searchfactory;

import java.lang.annotation.ElementType;
import java.util.Set;
import org.hibernate.search.SearchException;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.metadata.IndexedTypeDescriptor;
import org.hibernate.search.spi.SearchFactoryBuilder;
import org.hibernate.search.test.util.ManualConfiguration;
import org.jgroups.util.Util;
import org.junit.Assert;
import org.junit.Test;

public class SearchFactoryTest {
    @Test
    public void testTypeWithNoDocumentIdThrowsException() {
        ManualConfiguration cfg = this.getManualConfiguration();
        SearchMapping mapping = new SearchMapping();
        mapping.entity(Foo.class).indexed();
        cfg.setProgrammaticMapping(mapping);
        try {
            new SearchFactoryBuilder().configuration((SearchConfiguration)cfg).buildSearchFactory();
            Assert.fail((String)"Invalid configuration should have thrown an exception");
        }
        catch (SearchException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("HSEARCH000177"));
        }
    }

    @Test
    public void testGetIndexedTypesNoTypeIndexed() {
        ManualConfiguration cfg = this.getManualConfiguration();
        SearchFactoryImplementor sf = new SearchFactoryBuilder().configuration((SearchConfiguration)cfg).buildSearchFactory();
        Set indexedClasses = sf.getIndexedTypes();
        Assert.assertEquals((String)"Wrong number of indexed entities", (long)0L, (long)indexedClasses.size());
    }

    @Test
    public void testGetIndexedTypeSingleIndexedType() {
        ManualConfiguration cfg = this.getManualConfiguration();
        SearchMapping mapping = new SearchMapping();
        mapping.entity(Foo.class).indexed().property("id", ElementType.FIELD).documentId();
        cfg.setProgrammaticMapping(mapping);
        SearchFactoryImplementor sf = new SearchFactoryBuilder().configuration((SearchConfiguration)cfg).buildSearchFactory();
        Set indexedClasses = sf.getIndexedTypes();
        Assert.assertEquals((String)"Wrong number of indexed entities", (long)1L, (long)indexedClasses.size());
        Assert.assertTrue((boolean)((Class)indexedClasses.iterator().next()).equals(Foo.class));
    }

    @Test
    public void testGetIndexedTypesMultipleTypes() {
        ManualConfiguration cfg = this.getManualConfiguration();
        SearchMapping mapping = new SearchMapping();
        mapping.entity(Foo.class).indexed().property("id", ElementType.FIELD).documentId().entity(Bar.class).indexed().property("id", ElementType.FIELD).documentId();
        cfg.setProgrammaticMapping(mapping);
        SearchFactoryImplementor sf = new SearchFactoryBuilder().configuration((SearchConfiguration)cfg).buildSearchFactory();
        Set indexedClasses = sf.getIndexedTypes();
        Assert.assertEquals((String)"Wrong number of indexed entities", (long)2L, (long)indexedClasses.size());
    }

    @Test
    public void testGetTypeDescriptorForUnindexedType() {
        ManualConfiguration cfg = this.getManualConfiguration();
        SearchFactoryImplementor sf = new SearchFactoryBuilder().configuration((SearchConfiguration)cfg).buildSearchFactory();
        IndexedTypeDescriptor indexedTypeDescriptor = sf.getIndexedTypeDescriptor(Foo.class);
        Assert.assertNotNull((Object)indexedTypeDescriptor);
        Util.assertFalse((boolean)indexedTypeDescriptor.isIndexed());
    }

    @Test
    public void testGetTypeDescriptorForIndexedType() {
        ManualConfiguration cfg = this.getManualConfiguration();
        SearchMapping mapping = new SearchMapping();
        mapping.entity(Foo.class).indexed().property("id", ElementType.FIELD).documentId();
        cfg.setProgrammaticMapping(mapping);
        SearchFactoryImplementor sf = new SearchFactoryBuilder().configuration((SearchConfiguration)cfg).buildSearchFactory();
        IndexedTypeDescriptor indexedTypeDescriptor = sf.getIndexedTypeDescriptor(Foo.class);
        Assert.assertNotNull((Object)indexedTypeDescriptor);
        Assert.assertTrue((boolean)indexedTypeDescriptor.isIndexed());
    }

    private ManualConfiguration getManualConfiguration() {
        ManualConfiguration cfg = new ManualConfiguration();
        cfg.addProperty("hibernate.search.default.directory_provider", "ram");
        cfg.addClass(Foo.class);
        cfg.addClass(Bar.class);
        return cfg;
    }

    public static class Bar {
        private long id;
    }

    public static class Foo {
        private long id;
    }
}

