/*
 * Hibernate, Relational Persistence for Idiomatic Java
 *
 * Copyright (c) 2014, Red Hat, Inc. and/or its affiliates or third-party contributors as
 * indicated by the @author tags or express copyright attribution
 * statements applied by the authors.  All third-party contributions are
 * distributed under license by Red Hat, Inc.
 *
 * This copyrighted material is made available to anyone wishing to use, modify,
 * copy, or redistribute it subject to the terms and conditions of the GNU
 * Lesser General Public License, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this distribution; if not, write to:
 * Free Software Foundation, Inc.
 * 51 Franklin Street, Fifth Floor
 * Boston, MA  02110-1301  USA
 */
package org.hibernate.search.backend.impl.lucene;

import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.LockSupport;

/**
 * A Changeset is a work to be applied to the index and its associated producer
 *
 * @author gustavonalle
 */
final class Changeset {

	private final List<LuceneWork> workList;
	private final Thread producer;
	private final IndexingMonitor monitor;
	private volatile boolean processed = false;

	Changeset(List<LuceneWork> workList, Thread producer, IndexingMonitor monitor) {
		this.workList = workList;
		this.producer = producer;
		this.monitor = monitor;
	}

	Iterator<LuceneWork> getWorkListIterator() {
		return workList.iterator();
	}

	IndexingMonitor getMonitor() {
		return monitor;
	}

	boolean isProcessed() {
		return processed;
	}

	public void markProcessed() {
		processed = true;
		LockSupport.unpark( producer );
	}

}
