/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.backend.lucene;

import java.util.Random;
import org.hibernate.search.test.util.textbuilder.SentenceInventor;

public class RandomGenerator {
    private static final int DEFAULT_MAX_WORD_SIZE = 20;
    private final int maxWordSize;
    private static final Random r = new Random();
    private static final SentenceInventor sentenceInventor = new SentenceInventor(3L, 10000);

    private RandomGenerator() {
        this.maxWordSize = 20;
    }

    private RandomGenerator(int maxWordSize) {
        this.maxWordSize = maxWordSize;
    }

    public static RandomGenerator withDefaults() {
        return new RandomGenerator(20);
    }

    public static RandomGenerator create(int maxWordSize, int maxPhraseSize) {
        return new RandomGenerator(maxWordSize);
    }

    public int randomIntNotZero(int max) {
        return r.nextInt(max - 1) + 1;
    }

    public double randomDouble() {
        return Math.random();
    }

    public final <T> T oneOf(T ... choices) {
        return choices[this.randomIntNotZero(choices.length + 1) - 1];
    }

    public String generateRandomWord() {
        return sentenceInventor.randomString(this.maxWordSize);
    }

    public String generateRandomPhrase() {
        return sentenceInventor.nextSentence();
    }
}

