/*
 * Hibernate, Relational Persistence for Idiomatic Java
 *
 * JBoss, Home of Professional Open Source
 * Copyright 2011 Red Hat Inc. and/or its affiliates and other contributors
 * as indicated by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
package org.hibernate.search.indexes.serialization.spi;

import org.hibernate.search.engine.service.spi.Service;
import org.hibernate.search.engine.service.spi.Startable;

/**
 * Provides access to a serializer and deserializer to send the necessary work load for remote backends over the wire.
 * <p>
 * Note: Providers are encouraged to offer a backward and forward compatible protocol.
 * </p>
 * <p>
 * Implementors are encouraged to implement a descriptive {@code toString()}
 * method for logging purposes.
 * </p>
 *
 * @author Emmanuel Bernard <emmanuel@hibernate.org>
 * @author Hardy Ferentschik
 */
public interface SerializationProvider extends Service, Startable {
	Serializer getSerializer();

	Deserializer getDeserializer();
}
