/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.util.Version;
import org.hibernate.annotations.common.reflection.XAnnotatedElement;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XMember;
import org.hibernate.annotations.common.reflection.XPackage;
import org.hibernate.search.Environment;
import org.hibernate.search.SearchException;
import org.hibernate.search.annotations.AnalyzerDef;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.cfg.EntityDescriptor;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.impl.SolrAnalyzerBuilder;
import org.hibernate.search.util.StringHelper;
import org.hibernate.search.util.impl.ClassLoaderHelper;
import org.hibernate.search.util.impl.DelegateNamedAnalyzer;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public final class ConfigContext {
    private static final Log log = LoggerFactory.make();
    private static final String DEFAULT_NULL_INDEX_TOKEN = "_null_";
    private static final String PROGRAMMATIC_ANALYZER_DEFINITION = "PROGRAMMATIC_ANALYZER_DEFINITION";
    private final Map<String, String> analyzerDefinitionPoints = new HashMap<String, String>();
    private final Map<String, AnalyzerDef> analyzerDefs = new HashMap<String, AnalyzerDef>();
    private final List<DelegateNamedAnalyzer> lazyAnalyzers = new ArrayList<DelegateNamedAnalyzer>();
    private final Analyzer defaultAnalyzer;
    private final boolean jpaPresent;
    private final Version luceneMatchVersion;
    private final String nullToken;
    private final boolean implicitProvidedId;
    private final SearchMapping searchMapping;

    public ConfigContext(SearchConfiguration cfg) {
        this(cfg, null);
    }

    public ConfigContext(SearchConfiguration cfg, SearchMapping searchMapping) {
        this.luceneMatchVersion = this.getLuceneMatchVersion(cfg);
        this.defaultAnalyzer = this.initAnalyzer(cfg);
        this.jpaPresent = this.isPresent("javax.persistence.Id");
        this.nullToken = this.initNullToken(cfg);
        this.implicitProvidedId = cfg.isIdProvidedImplicit();
        this.searchMapping = searchMapping;
    }

    public void addAnalyzerDef(AnalyzerDef analyzerDef, XAnnotatedElement annotatedElement) {
        if (analyzerDef == null) {
            return;
        }
        this.addAnalyzerDef(analyzerDef, this.buildAnnotationDefinitionPoint(annotatedElement));
    }

    public void addGlobalAnalyzerDef(AnalyzerDef analyzerDef) {
        this.addAnalyzerDef(analyzerDef, PROGRAMMATIC_ANALYZER_DEFINITION);
    }

    private void addAnalyzerDef(AnalyzerDef analyzerDef, String annotationDefinitionPoint) {
        String analyzerDefinitionName = analyzerDef.name();
        if (this.analyzerDefinitionPoints.containsKey(analyzerDefinitionName)) {
            if (!this.analyzerDefinitionPoints.get(analyzerDefinitionName).equals(annotationDefinitionPoint)) {
                throw new SearchException("Multiple analyzer definitions with the same name: " + analyzerDef.name());
            }
        } else {
            this.analyzerDefs.put(analyzerDefinitionName, analyzerDef);
            this.analyzerDefinitionPoints.put(analyzerDefinitionName, annotationDefinitionPoint);
        }
    }

    public Analyzer buildLazyAnalyzer(String name) {
        DelegateNamedAnalyzer delegateNamedAnalyzer = new DelegateNamedAnalyzer(name);
        this.lazyAnalyzers.add(delegateNamedAnalyzer);
        return delegateNamedAnalyzer;
    }

    private Analyzer initAnalyzer(SearchConfiguration cfg) {
        Class analyzerClass;
        String analyzerClassName = cfg.getProperty("hibernate.search.analyzer");
        if (analyzerClassName != null) {
            try {
                analyzerClass = ClassLoaderHelper.classForName(analyzerClassName, cfg.getClass().getClassLoader());
            }
            catch (Exception e) {
                return this.buildLazyAnalyzer(analyzerClassName);
            }
        } else {
            analyzerClass = StandardAnalyzer.class;
        }
        return ClassLoaderHelper.analyzerInstanceFromClass(analyzerClass, this.luceneMatchVersion);
    }

    private String initNullToken(SearchConfiguration cfg) {
        String defaultNullIndexToken = cfg.getProperty("hibernate.search.default_null_token");
        if (StringHelper.isEmpty(defaultNullIndexToken)) {
            defaultNullIndexToken = DEFAULT_NULL_INDEX_TOKEN;
        }
        return defaultNullIndexToken;
    }

    public String getDefaultNullToken() {
        return this.nullToken;
    }

    public Analyzer getDefaultAnalyzer() {
        return this.defaultAnalyzer;
    }

    public Version getLuceneMatchVersion() {
        return this.luceneMatchVersion;
    }

    public Map<String, Analyzer> initLazyAnalyzers() {
        HashMap<String, Analyzer> initializedAnalyzers = new HashMap<String, Analyzer>(this.analyzerDefs.size());
        for (DelegateNamedAnalyzer delegateNamedAnalyzer : this.lazyAnalyzers) {
            String name = delegateNamedAnalyzer.getName();
            if (initializedAnalyzers.containsKey(name)) {
                delegateNamedAnalyzer.setDelegate((Analyzer)initializedAnalyzers.get(name));
                continue;
            }
            if (this.analyzerDefs.containsKey(name)) {
                Analyzer analyzer = this.buildAnalyzer(this.analyzerDefs.get(name));
                delegateNamedAnalyzer.setDelegate(analyzer);
                initializedAnalyzers.put(name, analyzer);
                continue;
            }
            throw new SearchException("Analyzer found with an unknown definition: " + name);
        }
        for (Map.Entry entry : this.analyzerDefs.entrySet()) {
            if (initializedAnalyzers.containsKey(entry.getKey())) continue;
            Analyzer analyzer = this.buildAnalyzer((AnalyzerDef)entry.getValue());
            initializedAnalyzers.put((String)entry.getKey(), analyzer);
        }
        return Collections.unmodifiableMap(initializedAnalyzers);
    }

    private Analyzer buildAnalyzer(AnalyzerDef analyzerDef) {
        try {
            return SolrAnalyzerBuilder.buildAnalyzer(analyzerDef, this.luceneMatchVersion);
        }
        catch (IOException e) {
            throw new SearchException("Could not initializer Analyzer definitition" + analyzerDef, e);
        }
    }

    public boolean isJpaPresent() {
        return this.jpaPresent;
    }

    private boolean isPresent(String className) {
        try {
            ClassLoaderHelper.classForName(className, ConfigContext.class.getClassLoader());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private Version getLuceneMatchVersion(SearchConfiguration cfg) {
        Version version;
        String tmp = cfg.getProperty("hibernate.search.lucene_version");
        if (StringHelper.isEmpty(tmp)) {
            log.recommendConfiguringLuceneVersion();
            version = Environment.DEFAULT_LUCENE_MATCH_VERSION;
        } else {
            try {
                version = Version.valueOf((String)tmp);
                if (log.isDebugEnabled()) {
                    log.debug("Setting Lucene compatibility to Version " + version.name());
                }
            }
            catch (IllegalArgumentException e) {
                StringBuilder msg = new StringBuilder(tmp);
                msg.append(" is a invalid value for the Lucene match version. Possible values are: ");
                for (Version v : Version.values()) {
                    msg.append(v.toString());
                    msg.append(", ");
                }
                msg.delete(msg.lastIndexOf(","), msg.length() - 1);
                throw new SearchException(msg.toString());
            }
        }
        return version;
    }

    private String buildAnnotationDefinitionPoint(XAnnotatedElement annotatedElement) {
        if (annotatedElement instanceof XClass) {
            return ((XClass)annotatedElement).getName();
        }
        if (annotatedElement instanceof XMember) {
            XMember member = (XMember)annotatedElement;
            return member.getType().getName() + '.' + member.getName();
        }
        if (annotatedElement instanceof XPackage) {
            return ((XPackage)annotatedElement).getName();
        }
        throw new SearchException("Unknown XAnnoatedElement: " + annotatedElement);
    }

    public boolean isProvidedIdImplicit() {
        return this.implicitProvidedId;
    }

    public Map<FieldBridge, ClassBridge> getClassBridgeInstances(Class<?> type) {
        EntityDescriptor entityDescriptor;
        Map<FieldBridge, ClassBridge> classBridgeInstances = null;
        if (this.searchMapping != null && (entityDescriptor = this.searchMapping.getEntityDescriptor(type)) != null) {
            classBridgeInstances = entityDescriptor.getClassBridgeConfigurations();
        }
        return classBridgeInstances != null ? classBridgeInstances : Collections.emptyMap();
    }
}

