/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.impl;

import java.util.Properties;
import java.util.Set;
import org.apache.lucene.search.similarities.Similarity;
import org.hibernate.search.cfg.spi.IndexManagerFactory;
import org.hibernate.search.engine.impl.DynamicShardingStrategy;
import org.hibernate.search.engine.impl.MutableEntityIndexBinding;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.indexes.impl.IndexManagerHolder;
import org.hibernate.search.indexes.interceptor.EntityIndexingInterceptor;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.query.collector.impl.FieldCacheCollectorFactory;
import org.hibernate.search.store.IndexShardingStrategy;
import org.hibernate.search.store.ShardIdentifierProvider;

public class DynamicShardingEntityIndexBinding<T>
implements MutableEntityIndexBinding<T> {
    private final DynamicShardingStrategy shardingStrategy;
    private final Similarity similarityInstance;
    private final ShardIdentifierProvider shardIdentityProvider;
    private final Properties properties;
    private final SearchFactoryImplementor searchFactory;
    private final IndexManagerHolder indexManagerHolder;
    private final String rootDirectoryProviderName;
    private DocumentBuilderIndexedEntity<T> documentBuilder;
    private final EntityIndexingInterceptor entityIndexingInterceptor;
    private IndexManagerFactory indexManagerFactory;

    public DynamicShardingEntityIndexBinding(ShardIdentifierProvider shardIdentityProvider, Similarity similarityInstance, EntityIndexingInterceptor<? super T> entityIndexingInterceptor, Properties properties, SearchFactoryImplementor searchFactoryImplementor, IndexManagerHolder indexManagerHolder, String rootDirectoryProviderName) {
        this.shardIdentityProvider = shardIdentityProvider;
        this.similarityInstance = similarityInstance;
        this.entityIndexingInterceptor = entityIndexingInterceptor;
        this.properties = properties;
        this.searchFactory = searchFactoryImplementor;
        this.indexManagerFactory = this.indexManagerFactory;
        this.indexManagerHolder = indexManagerHolder;
        this.rootDirectoryProviderName = rootDirectoryProviderName;
        this.shardingStrategy = new DynamicShardingStrategy(shardIdentityProvider, indexManagerHolder, this, rootDirectoryProviderName);
    }

    @Override
    public void setDocumentBuilderIndexedEntity(DocumentBuilderIndexedEntity<T> documentBuilder) {
        this.documentBuilder = documentBuilder;
    }

    @Override
    public Similarity getSimilarity() {
        return this.similarityInstance;
    }

    @Override
    public IndexShardingStrategy getSelectionStrategy() {
        return this.shardingStrategy;
    }

    @Override
    public ShardIdentifierProvider getShardIdentifierProvider() {
        return this.shardingStrategy.getShardIdentifierProvider();
    }

    public DocumentBuilderIndexedEntity<T> getDocumentBuilder() {
        return this.documentBuilder;
    }

    @Override
    public FieldCacheCollectorFactory getIdFieldCacheCollectionFactory() {
        return this.documentBuilder.getIdFieldCacheCollectionFactory();
    }

    @Override
    public void postInitialize(Set<Class<?>> indexedClasses) {
        this.documentBuilder.postInitialize(indexedClasses);
    }

    @Override
    public IndexManager[] getIndexManagers() {
        return this.shardingStrategy.getIndexManagersForAllShards();
    }

    public EntityIndexingInterceptor getEntityIndexingInterceptor() {
        return this.entityIndexingInterceptor;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public SearchFactoryImplementor getSearchFactory() {
        return this.searchFactory;
    }

    public IndexManagerFactory getIndexManagerFactory() {
        return this.indexManagerFactory;
    }

    public <T> MutableEntityIndexBinding<T> cloneWithSimilarity(Similarity entitySimilarity) {
        return new DynamicShardingEntityIndexBinding<T>(this.shardIdentityProvider, entitySimilarity, this.entityIndexingInterceptor, this.properties, this.searchFactory, this.indexManagerHolder, this.rootDirectoryProviderName);
    }
}

