/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.impl;

import java.util.Map;
import java.util.Properties;
import org.apache.lucene.analysis.Analyzer;
import org.hibernate.search.backend.spi.BackendQueueProcessor;
import org.hibernate.search.backend.spi.Worker;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.cfg.spi.IndexManagerFactory;
import org.hibernate.search.engine.impl.FilterDef;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.engine.spi.DocumentBuilderContainedEntity;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.engine.spi.TimingSource;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.filter.FilterCachingStrategy;
import org.hibernate.search.indexes.impl.IndexManagerHolder;
import org.hibernate.search.query.engine.spi.TimeoutExceptionFactory;
import org.hibernate.search.spi.InstanceInitializer;
import org.hibernate.search.spi.impl.PolymorphicIndexHierarchy;
import org.hibernate.search.spi.impl.SearchFactoryImplementorWithShareableState;
import org.hibernate.search.spi.impl.SearchFactoryState;

public class MutableSearchFactoryState
implements SearchFactoryState {
    private Map<Class<?>, DocumentBuilderContainedEntity<?>> documentBuildersContainedEntities;
    private Map<Class<?>, EntityIndexBinding> indexBindingsPerEntity;
    private String indexingStrategy;
    private Worker worker;
    private BackendQueueProcessor backendQueueProcessor;
    private Map<String, FilterDef> filterDefinitions;
    private FilterCachingStrategy filterCachingStrategy;
    private Map<String, Analyzer> analyzers;
    private int cacheBitResultsSize;
    private Properties configurationProperties;
    private PolymorphicIndexHierarchy indexHierarchy;
    private ServiceManager serviceManager;
    private boolean transactionManagerExpected;
    private IndexManagerHolder allIndexesManager;
    private ErrorHandler errorHandler;
    private TimeoutExceptionFactory defaultTimeoutExceptionFactory;
    private InstanceInitializer instanceInitializer;
    private TimingSource timingSource;
    private SearchMapping mapping;
    private boolean indexMetadataIsComplete;
    private boolean isIdProvidedImplicit;
    private IndexManagerFactory indexManagerFactory;

    public void copyStateFromOldFactory(SearchFactoryState oldFactoryState) {
        this.indexingStrategy = oldFactoryState.getIndexingStrategy();
        this.indexBindingsPerEntity = oldFactoryState.getIndexBindings();
        this.documentBuildersContainedEntities = oldFactoryState.getDocumentBuildersContainedEntities();
        this.worker = oldFactoryState.getWorker();
        this.filterDefinitions = oldFactoryState.getFilterDefinitions();
        this.filterCachingStrategy = oldFactoryState.getFilterCachingStrategy();
        this.analyzers = oldFactoryState.getAnalyzers();
        this.cacheBitResultsSize = oldFactoryState.getCacheBitResultsSize();
        this.configurationProperties = oldFactoryState.getConfigurationProperties();
        this.indexHierarchy = oldFactoryState.getIndexHierarchy();
        this.serviceManager = oldFactoryState.getServiceManager();
        this.transactionManagerExpected = oldFactoryState.isTransactionManagerExpected();
        this.allIndexesManager = oldFactoryState.getAllIndexesManager();
        this.errorHandler = oldFactoryState.getErrorHandler();
        this.defaultTimeoutExceptionFactory = oldFactoryState.getDefaultTimeoutExceptionFactory();
        this.instanceInitializer = oldFactoryState.getInstanceInitializer();
        this.timingSource = oldFactoryState.getTimingSource();
        this.mapping = oldFactoryState.getProgrammaticMapping();
        this.indexMetadataIsComplete = oldFactoryState.isIndexMetadataComplete();
        this.isIdProvidedImplicit = oldFactoryState.isIdProvidedImplicit();
        this.indexManagerFactory = oldFactoryState.getIndexManagerFactory();
    }

    @Override
    public ServiceManager getServiceManager() {
        return this.serviceManager;
    }

    public void setServiceManager(ServiceManager serviceManager) {
        this.serviceManager = serviceManager;
    }

    @Override
    public Map<Class<?>, DocumentBuilderContainedEntity<?>> getDocumentBuildersContainedEntities() {
        return this.documentBuildersContainedEntities;
    }

    @Override
    public Map<Class<?>, EntityIndexBinding> getIndexBindings() {
        return this.indexBindingsPerEntity;
    }

    @Override
    public String getIndexingStrategy() {
        return this.indexingStrategy;
    }

    @Override
    public Worker getWorker() {
        return this.worker;
    }

    public BackendQueueProcessor getBackendQueueProcessor() {
        return this.backendQueueProcessor;
    }

    @Override
    public Map<String, FilterDef> getFilterDefinitions() {
        return this.filterDefinitions;
    }

    @Override
    public FilterCachingStrategy getFilterCachingStrategy() {
        return this.filterCachingStrategy;
    }

    @Override
    public Map<String, Analyzer> getAnalyzers() {
        return this.analyzers;
    }

    @Override
    public int getCacheBitResultsSize() {
        return this.cacheBitResultsSize;
    }

    @Override
    public Properties getConfigurationProperties() {
        return this.configurationProperties;
    }

    @Override
    public PolymorphicIndexHierarchy getIndexHierarchy() {
        return this.indexHierarchy;
    }

    public void setDocumentBuildersContainedEntities(Map<Class<?>, DocumentBuilderContainedEntity<?>> documentBuildersContainedEntities) {
        this.documentBuildersContainedEntities = documentBuildersContainedEntities;
    }

    public void setDocumentBuildersIndexedEntities(Map<Class<?>, EntityIndexBinding> documentBuildersIndexedEntities) {
        this.indexBindingsPerEntity = documentBuildersIndexedEntities;
    }

    public void setIndexingStrategy(String indexingStrategy) {
        this.indexingStrategy = indexingStrategy;
    }

    public void setWorker(Worker worker) {
        this.worker = worker;
    }

    public void setBackendQueueProcessor(BackendQueueProcessor backendQueueProcessor) {
        this.backendQueueProcessor = backendQueueProcessor;
    }

    public void setFilterDefinitions(Map<String, FilterDef> filterDefinitions) {
        this.filterDefinitions = filterDefinitions;
    }

    public void setFilterCachingStrategy(FilterCachingStrategy filterCachingStrategy) {
        this.filterCachingStrategy = filterCachingStrategy;
    }

    public void setAnalyzers(Map<String, Analyzer> analyzers) {
        this.analyzers = analyzers;
    }

    public void setCacheBitResultsSize(int cacheBitResultsSize) {
        this.cacheBitResultsSize = cacheBitResultsSize;
    }

    public void setConfigurationProperties(Properties configurationProperties) {
        this.configurationProperties = configurationProperties;
    }

    public void setIndexHierarchy(PolymorphicIndexHierarchy indexHierarchy) {
        this.indexHierarchy = indexHierarchy;
    }

    @Override
    public boolean isTransactionManagerExpected() {
        return this.transactionManagerExpected;
    }

    public void setTransactionManagerExpected(boolean transactionManagerExpected) {
        this.transactionManagerExpected = transactionManagerExpected;
    }

    public void setAllIndexesManager(IndexManagerHolder indexesFactory) {
        this.allIndexesManager = indexesFactory;
    }

    @Override
    public IndexManagerHolder getAllIndexesManager() {
        return this.allIndexesManager;
    }

    public void setActiveSearchFactory(SearchFactoryImplementorWithShareableState factory) {
        this.allIndexesManager.setActiveSearchFactory(factory);
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Override
    public InstanceInitializer getInstanceInitializer() {
        return this.instanceInitializer;
    }

    public void setInstanceInitializer(InstanceInitializer instanceInitializer) {
        this.instanceInitializer = instanceInitializer;
    }

    @Override
    public TimeoutExceptionFactory getDefaultTimeoutExceptionFactory() {
        return this.defaultTimeoutExceptionFactory;
    }

    public void setDefaultTimeoutExceptionFactory(TimeoutExceptionFactory defaultTimeoutExceptionFactory) {
        this.defaultTimeoutExceptionFactory = defaultTimeoutExceptionFactory;
    }

    @Override
    public TimingSource getTimingSource() {
        return this.timingSource;
    }

    public void setTimingSource(TimingSource timingSource) {
        this.timingSource = timingSource;
    }

    public void setProgrammaticMapping(SearchMapping mapping) {
        this.mapping = mapping;
    }

    @Override
    public SearchMapping getProgrammaticMapping() {
        return this.mapping;
    }

    public void setSearchMapping(SearchMapping mapping) {
        this.mapping = mapping;
    }

    @Override
    public boolean isIndexMetadataComplete() {
        return this.indexMetadataIsComplete;
    }

    public void setIndexMetadataComplete(boolean indexMetadataIsComplete) {
        this.indexMetadataIsComplete = indexMetadataIsComplete;
    }

    @Override
    public boolean isIdProvidedImplicit() {
        return this.isIdProvidedImplicit;
    }

    public void setIdProvidedImplicit(boolean idProvidedImplicit) {
        this.isIdProvidedImplicit = idProvidedImplicit;
    }

    @Override
    public IndexManagerFactory getIndexManagerFactory() {
        return this.indexManagerFactory;
    }

    public void setIndexManagerFactory(IndexManagerFactory indexManagerFactory) {
        this.indexManagerFactory = indexManagerFactory;
    }
}

