/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.bridge.util.impl;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public final class NumericFieldUtils {
    private static final Log log = LoggerFactory.make();

    private NumericFieldUtils() {
    }

    public static Query createNumericRangeQuery(String fieldName, Object from, Object to, boolean includeLower, boolean includeUpper) {
        Class<Serializable> numericClass;
        if (from != null) {
            numericClass = from.getClass();
        } else if (to != null) {
            numericClass = to.getClass();
        } else {
            throw log.rangeQueryWithNullToAndFromValue(fieldName);
        }
        if (numericClass.isAssignableFrom(Double.class)) {
            return NumericRangeQuery.newDoubleRange((String)fieldName, (Double)((Double)from), (Double)((Double)to), (boolean)includeLower, (boolean)includeUpper);
        }
        if (numericClass.isAssignableFrom(Long.class)) {
            return NumericRangeQuery.newLongRange((String)fieldName, (Long)((Long)from), (Long)((Long)to), (boolean)includeLower, (boolean)includeUpper);
        }
        if (numericClass.isAssignableFrom(Integer.class)) {
            return NumericRangeQuery.newIntRange((String)fieldName, (Integer)((Integer)from), (Integer)((Integer)to), (boolean)includeLower, (boolean)includeUpper);
        }
        if (numericClass.isAssignableFrom(Float.class)) {
            return NumericRangeQuery.newFloatRange((String)fieldName, (Float)((Float)from), (Float)((Float)to), (boolean)includeLower, (boolean)includeUpper);
        }
        if (numericClass.isAssignableFrom(Date.class)) {
            Long fromValue = from != null ? Long.valueOf(((Date)from).getTime()) : null;
            Long toValue = to != null ? Long.valueOf(((Date)to).getTime()) : null;
            return NumericRangeQuery.newLongRange((String)fieldName, (Long)fromValue, (Long)toValue, (boolean)includeLower, (boolean)includeUpper);
        }
        if (numericClass.isAssignableFrom(Date.class)) {
            Long fromValue = from != null ? Long.valueOf(((Date)from).getTime()) : null;
            Long toValue = to != null ? Long.valueOf(((Date)to).getTime()) : null;
            return NumericRangeQuery.newLongRange((String)fieldName, (Long)fromValue, (Long)toValue, (boolean)includeLower, (boolean)includeUpper);
        }
        if (numericClass.isAssignableFrom(Calendar.class)) {
            Long fromValue = from != null ? Long.valueOf(((Calendar)from).getTime().getTime()) : null;
            Long toValue = to != null ? Long.valueOf(((Calendar)to).getTime().getTime()) : null;
            return NumericRangeQuery.newLongRange((String)fieldName, (Long)fromValue, (Long)toValue, (boolean)includeLower, (boolean)includeUpper);
        }
        throw log.numericRangeQueryWithNonNumericToAndFromValues(fieldName);
    }

    public static Query createExactMatchQuery(String fieldName, Object value) {
        return NumericFieldUtils.createNumericRangeQuery(fieldName, value, value, true, true);
    }
}

