/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.zip.DataFormatException;
import org.apache.lucene.document.CompressionTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.bridge.spi.ConversionContext;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.engine.metadata.impl.DocumentFieldMetadata;
import org.hibernate.search.engine.metadata.impl.EmbeddedTypeMetadata;
import org.hibernate.search.engine.metadata.impl.PropertyMetadata;
import org.hibernate.search.engine.metadata.impl.TypeMetadata;
import org.hibernate.search.engine.service.classloading.spi.ClassLoadingException;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.util.impl.ClassLoaderHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public final class DocumentBuilderHelper {
    private static final Log log = LoggerFactory.make();
    private static final Object NOT_SET = new Object();

    private DocumentBuilderHelper() {
    }

    public static Class<?> getDocumentClass(String className, ServiceManager serviceManager) {
        try {
            return ClassLoaderHelper.classForName(className, serviceManager);
        }
        catch (ClassLoadingException e) {
            throw new SearchException("Unable to load indexed class: " + className, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Serializable getDocumentId(ExtendedSearchIntegrator extendedIntegrator, Class<?> clazz, Document document, ConversionContext conversionContext) {
        DocumentBuilderIndexedEntity builderIndexedEntity = DocumentBuilderHelper.getDocumentBuilder(extendedIntegrator, clazz);
        TwoWayFieldBridge fieldBridge = builderIndexedEntity.getIdBridge();
        String fieldName = builderIndexedEntity.getIdKeywordName();
        try {
            Serializable serializable = (Serializable)conversionContext.setClass(clazz).pushIdentifierProperty().twoWayConversionContext(fieldBridge).get(fieldName, document);
            return serializable;
        }
        finally {
            conversionContext.popProperty();
        }
    }

    public static String getDocumentIdName(ExtendedSearchIntegrator extendedIntegrator, Class<?> clazz) {
        DocumentBuilderIndexedEntity documentBuilder = DocumentBuilderHelper.getDocumentBuilder(extendedIntegrator, clazz);
        return documentBuilder.getIdentifierName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object[] getDocumentFields(ExtendedSearchIntegrator extendedIntegrator, Class<?> clazz, Document document, String[] fields, ConversionContext conversionContext) {
        String fieldName;
        int matchingPosition;
        DocumentBuilderIndexedEntity builderIndexedEntity = DocumentBuilderHelper.getDocumentBuilder(extendedIntegrator, clazz);
        int fieldNbr = fields.length;
        Object[] result = new Object[fieldNbr];
        Arrays.fill(result, NOT_SET);
        conversionContext.setClass(clazz);
        if (builderIndexedEntity.getIdKeywordName() != null && (matchingPosition = DocumentBuilderHelper.getFieldPosition(fields, fieldName = builderIndexedEntity.getIdKeywordName())) != -1) {
            conversionContext.pushProperty(fieldName);
            try {
                DocumentBuilderHelper.populateResult(fieldName, builderIndexedEntity.getIdBridge(), Store.YES, result, document, conversionContext, matchingPosition);
            }
            finally {
                conversionContext.popProperty();
            }
        }
        TypeMetadata metadata = builderIndexedEntity.getMetadata();
        DocumentBuilderHelper.processFieldsForProjection(metadata, fields, result, document, conversionContext);
        return result;
    }

    public static void populateResult(String fieldName, FieldBridge fieldBridge, Store store, Object[] result, Document document, ConversionContext conversionContext, int matchingPosition) {
        if (store != Store.NO && TwoWayFieldBridge.class.isAssignableFrom(fieldBridge.getClass())) {
            result[matchingPosition] = conversionContext.twoWayConversionContext((TwoWayFieldBridge)fieldBridge).get(fieldName, document);
            if (log.isTraceEnabled()) {
                log.tracef("Field %s projected as %s", fieldName, result[matchingPosition]);
            }
        } else {
            if (store == Store.NO) {
                throw new SearchException("Projecting an unstored field: " + fieldName);
            }
            throw new SearchException("FieldBridge is not a TwoWayFieldBridge: " + fieldBridge.getClass());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processFieldsForProjection(TypeMetadata typeMetadata, String[] fields, Object[] result, Document document, ConversionContext contextualBridge) {
        for (PropertyMetadata propertyMetadata : typeMetadata.getAllPropertyMetadata()) {
            for (DocumentFieldMetadata fieldMetadata : propertyMetadata.getFieldMetadata()) {
                String fieldName = fieldMetadata.getName();
                int matchingPosition = DocumentBuilderHelper.getFieldPosition(fields, fieldName);
                if (matchingPosition == -1) continue;
                contextualBridge.pushProperty(fieldName);
                try {
                    DocumentBuilderHelper.populateResult(fieldName, fieldMetadata.getFieldBridge(), fieldMetadata.getStore(), result, document, contextualBridge, matchingPosition);
                }
                finally {
                    contextualBridge.popProperty();
                }
            }
        }
        for (EmbeddedTypeMetadata embeddedTypeMetadata : typeMetadata.getEmbeddedTypeMetadata()) {
            if (embeddedTypeMetadata.getEmbeddedContainer() != EmbeddedTypeMetadata.Container.OBJECT) continue;
            contextualBridge.pushProperty(embeddedTypeMetadata.getEmbeddedFieldName());
            try {
                DocumentBuilderHelper.processFieldsForProjection(embeddedTypeMetadata, fields, result, document, contextualBridge);
            }
            finally {
                contextualBridge.popProperty();
            }
        }
        for (DocumentFieldMetadata fieldMetadata : typeMetadata.getClassBridgeMetadata()) {
            int matchingPosition = DocumentBuilderHelper.getFieldPosition(fields, fieldMetadata.getName());
            if (matchingPosition == -1) continue;
            DocumentBuilderHelper.populateResult(fieldMetadata.getName(), fieldMetadata.getFieldBridge(), fieldMetadata.getStore(), result, document, contextualBridge, matchingPosition);
        }
        for (int index = 0; index < result.length; ++index) {
            IndexableField field;
            if (result[index] != NOT_SET) continue;
            result[index] = null;
            if (document == null || (field = document.getField(fields[index])) == null) continue;
            result[index] = DocumentBuilderHelper.extractObjectFromFieldable(field);
        }
    }

    @Deprecated
    public static Object extractObjectFromFieldable(IndexableField field) {
        Number numericValue = field.numericValue();
        if (numericValue != null) {
            return numericValue;
        }
        return DocumentBuilderHelper.extractStringFromFieldable(field);
    }

    @Deprecated
    public static String extractStringFromFieldable(IndexableField field) {
        BytesRef binaryValue = field.binaryValue();
        if (binaryValue != null) {
            try {
                return CompressionTools.decompressString((BytesRef)binaryValue);
            }
            catch (DataFormatException e) {
                throw log.fieldLooksBinaryButDecompressionFailed(field.name());
            }
        }
        return field.stringValue();
    }

    public static int getFieldPosition(String[] fields, String fieldName) {
        int fieldNbr = fields.length;
        for (int index = 0; index < fieldNbr; ++index) {
            if (!fieldName.equals(fields[index])) continue;
            return index;
        }
        return -1;
    }

    private static DocumentBuilderIndexedEntity getDocumentBuilder(ExtendedSearchIntegrator extendedIntegrator, Class<?> clazz) {
        EntityIndexBinding entityIndexBinding = extendedIntegrator.getIndexBinding(clazz);
        if (entityIndexBinding == null) {
            throw new SearchException("No Lucene configuration set up for: " + clazz);
        }
        return entityIndexBinding.getDocumentBuilder();
    }
}

