/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.dsl;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.lucene.analysis.charfilter.HTMLStripCharFilterFactory;
import org.apache.lucene.analysis.core.LowerCaseFilterFactory;
import org.apache.lucene.analysis.core.StopFilterFactory;
import org.apache.lucene.analysis.ngram.NGramFilterFactory;
import org.apache.lucene.analysis.snowball.SnowballPorterFilterFactory;
import org.apache.lucene.analysis.standard.StandardFilterFactory;
import org.apache.lucene.analysis.standard.StandardTokenizerFactory;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hibernate.search.annotations.Factory;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.StringBridge;
import org.hibernate.search.bridge.util.impl.String2FieldBridgeAdaptor;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.query.dsl.BooleanJunction;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.dsl.RangeMatchingContext;
import org.hibernate.search.query.dsl.TermMatchingContext;
import org.hibernate.search.query.dsl.impl.ConnectedTermMatchingContext;
import org.hibernate.search.test.dsl.Animal;
import org.hibernate.search.test.dsl.Car;
import org.hibernate.search.test.dsl.Coffee;
import org.hibernate.search.test.dsl.CoffeeBrand;
import org.hibernate.search.test.dsl.Day;
import org.hibernate.search.test.dsl.Month;
import org.hibernate.search.test.dsl.RomanNumberFieldBridge;
import org.hibernate.search.test.dsl.SportsCar;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.junit.SearchITHelper;
import org.hibernate.search.testsupport.junit.SkipOnElasticsearch;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

public class DSLTest {
    private final Calendar calendar = GregorianCalendar.getInstance(TimeZone.getTimeZone("GMT"), Locale.ROOT);
    @Rule
    public final SearchFactoryHolder sfHolder = new SearchFactoryHolder(Month.class, Car.class, SportsCar.class, Animal.class, Day.class, CoffeeBrand.class, Coffee.class).withProperty("hibernate.search.model_mapping", MappingFactory.class.getName());
    private final SearchITHelper helper = new SearchITHelper(this.sfHolder);
    private Date february;

    @Before
    public void setUp() throws Exception {
        this.indexTestData();
    }

    @Test
    public void testUseOfFieldBridge() throws Exception {
        QueryBuilder monthQb = this.helper.queryBuilder(Month.class);
        Query query = monthQb.keyword().onField("monthValue").matching((Object)2).createQuery();
        this.helper.assertThat(query).from(Month.class).hasResultSize(1);
    }

    @Test
    public void testUseOfCustomFieldBridgeInstance() throws Exception {
        QueryBuilder monthQb = this.helper.queryBuilder(Month.class);
        ConnectedTermMatchingContext termMatchingContext = (ConnectedTermMatchingContext)monthQb.keyword().onField("monthValueAsRomanNumberFromClassBridge1");
        Query query = termMatchingContext.withFieldBridge((FieldBridge)new String2FieldBridgeAdaptor((StringBridge)new RomanNumberFieldBridge())).matching((Object)2).createQuery();
        this.helper.assertThat(query).from(Month.class).hasResultSize(1);
    }

    @Test
    public void testUseOfMultipleCustomFieldBridgeInstances() throws Exception {
        QueryBuilder monthQb = this.helper.queryBuilder(Month.class);
        ConnectedTermMatchingContext field1Context = (ConnectedTermMatchingContext)monthQb.keyword().onField("monthValueAsRomanNumberFromClassBridge1");
        ConnectedTermMatchingContext field2Context = (ConnectedTermMatchingContext)field1Context.withFieldBridge((FieldBridge)new String2FieldBridgeAdaptor((StringBridge)new RomanNumberFieldBridge())).andField("monthValueAsRomanNumberFromClassBridge2");
        Query query = field2Context.withFieldBridge((FieldBridge)new String2FieldBridgeAdaptor((StringBridge)new RomanNumberFieldBridge())).matching((Object)2).createQuery();
        this.helper.assertThat(query).from(Month.class).hasResultSize(1);
    }

    @Test
    public void testTermQueryOnAnalyzer() throws Exception {
        QueryBuilder monthQb = this.helper.queryBuilder(Month.class);
        Query query = monthQb.keyword().onField("mythology").matching((Object)"cold").createQuery();
        this.helper.assertThat(query).from(Month.class).hasResultSize(0);
        query = monthQb.keyword().onField("mythology").matching((Object)"colder darker").createQuery();
        this.helper.assertThat(query).from(Month.class).hasResultSize(1);
        query = monthQb.keyword().onField("mythology_stem").matching((Object)"snowboard").createQuery();
        this.helper.assertThat(query).from(Month.class).hasResultSize(1);
        query = monthQb.keyword().onField("mythology_ngram").matching((Object)"snobored").createQuery();
        this.helper.assertThat(query).from(Month.class).hasResultSize(1);
        query = ((TermMatchingContext)monthQb.keyword().onField("mythology").ignoreAnalyzer()).matching((Object)"Month").createQuery();
        this.helper.assertThat(query).from(Month.class).hasResultSize(0);
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-2785")
    public void testTermQueryOnNormalizer() throws Exception {
        QueryBuilder monthQb = this.helper.queryBuilder(Month.class);
        Query query = monthQb.keyword().onField("name").matching((Object)"February").createQuery();
        this.helper.assertThat(query).from(Month.class).hasResultSize(1);
        query = monthQb.keyword().onField("name").matching((Object)"february").createQuery();
        this.helper.assertThat(query).from(Month.class).hasResultSize(1);
        query = monthQb.keyword().onField("mythology_normalized").matching((Object)"Month of fake spring").createQuery();
        this.helper.assertThat(query).from(Month.class).hasResultSize(1);
        query = monthQb.keyword().onField("mythology_normalized").matching((Object)"month of fake spring").createQuery();
        this.helper.assertThat(query).from(Month.class).hasResultSize(1);
        query = monthQb.keyword().onField("mythology_normalized").matching((Object)"Month").createQuery();
        this.helper.assertThat(query).from(Month.class).hasResultSize(0);
        query = monthQb.keyword().onField("mythology_normalized").matching((Object)"month").createQuery();
        this.helper.assertThat(query).from(Month.class).hasResultSize(0);
    }

    @Test
    public void testFuzzyQuery() throws Exception {
        QueryBuilder monthQb = this.helper.queryBuilder(Month.class);
        Query query = monthQb.keyword().fuzzy().withEditDistanceUpTo(1).withPrefixLength(1).onField("mythology").matching((Object)"calder").createQuery();
        this.helper.assertThat(query).from(Month.class).hasResultSize(1);
    }

    @Test
    public void testFuzzyQueryOnMultipleFields() throws Exception {
        QueryBuilder monthQb = this.helper.queryBuilder(Month.class);
        Query query = monthQb.keyword().fuzzy().withEditDistanceUpTo(2).withPrefixLength(1).onFields(new String[]{"mythology", "history"}).matching((Object)"showboarding").createQuery();
        this.helper.assertThat(query).from(Month.class).hasResultSize(2);
    }

    @Test
    public void testWildcardQuery() throws Exception {
        QueryBuilder monthQb = this.helper.queryBuilder(Month.class);
        Query query = monthQb.keyword().wildcard().onField("mythology").matching((Object)"mon*").createQuery();
        this.helper.assertThat(query).from(Month.class).hasResultSize(3);
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-1811")
    public void testWildcardQueryOnMultipleFields() throws Exception {
        QueryBuilder monthQb = this.helper.queryBuilder(Month.class);
        Query query = monthQb.keyword().wildcard().onFields(new String[]{"mythology", "history"}).matching((Object)"snowbo*").createQuery();
        this.helper.assertThat(query).from(Month.class).matchesExactlyIds(Integer.valueOf(2), Integer.valueOf(3));
    }

    @Test
    public void testQueryCustomization() throws Exception {
        QueryBuilder monthQb = this.helper.queryBuilder(Month.class);
        Query query = monthQb.bool().should(monthQb.keyword().onField("mythology").matching((Object)"whitening").createQuery()).should(monthQb.keyword().onField("history").matching((Object)"whitening").createQuery()).createQuery();
        this.helper.assertThat(query).from(Month.class).matchesExactlyIds(Integer.valueOf(1), Integer.valueOf(2));
        query = monthQb.bool().should(monthQb.keyword().onField("mythology").matching((Object)"whitening").createQuery()).should(((TermMatchingContext)monthQb.keyword().onField("history").boostedTo(30.0f)).matching((Object)"whitening").createQuery()).createQuery();
        this.helper.assertThat(query).from(Month.class).matchesExactlyIds(Integer.valueOf(2), Integer.valueOf(1));
    }

    @Test
    public void testMultipleFields() throws Exception {
        QueryBuilder monthQb = this.helper.queryBuilder(Month.class);
        Query query = monthQb.keyword().onField("mythology").andField("history").matching((Object)"whitening").createQuery();
        this.helper.assertThat(query).from(Month.class).matchesExactlyIds(Integer.valueOf(1), Integer.valueOf(2));
        query = ((TermMatchingContext)monthQb.keyword().onFields(new String[]{"mythology", "history"}).boostedTo(30.0f)).matching((Object)"whitening").createQuery();
        this.helper.assertThat(query).from(Month.class).matchesExactlyIds(Integer.valueOf(1), Integer.valueOf(2));
        query = ((TermMatchingContext)monthQb.keyword().onField("mythology").andField("history").boostedTo(30.0f)).matching((Object)"whitening").createQuery();
        this.helper.assertThat(query).from(Month.class).matchesExactlyIds(Integer.valueOf(2), Integer.valueOf(1));
    }

    @Test
    public void testBoolean() throws Exception {
        QueryBuilder monthQb = this.helper.queryBuilder(Month.class);
        Query query = monthQb.bool().must(monthQb.keyword().onField("mythology").matching((Object)"colder").createQuery()).createQuery();
        this.helper.assertThat(query).from(Month.class).matchesExactlyIds(Integer.valueOf(1));
        query = monthQb.bool().should(monthQb.all().createQuery()).must(monthQb.keyword().onField("mythology").matching((Object)"colder").createQuery()).not().createQuery();
        this.helper.assertThat(query).from(Month.class).matchesExactlyIds(Integer.valueOf(2), Integer.valueOf(3));
        query = monthQb.bool().must(monthQb.keyword().onField("mythology").matching((Object)"colder").createQuery()).not().createQuery();
        this.helper.assertThat(query).from(Month.class).matchesExactlyIds(Integer.valueOf(2), Integer.valueOf(3));
        query = monthQb.all().except(new Query[]{monthQb.keyword().onField("mythology").matching((Object)"colder").createQuery()}).createQuery();
        this.helper.assertThat(query).from(Month.class).matchesExactlyIds(Integer.valueOf(2), Integer.valueOf(3));
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-2034")
    public void testBooleanWithoutScoring() throws Exception {
        QueryBuilder monthQb = this.helper.queryBuilder(Month.class);
        Query query = monthQb.bool().must(monthQb.keyword().onField("mythology").matching((Object)"colder").createQuery()).disableScoring().createQuery();
        this.helper.assertThat(query).from(Month.class).matchesExactlyIds(Integer.valueOf(1));
        Assert.assertTrue((boolean)(query instanceof BooleanQuery));
        BooleanQuery bq = (BooleanQuery)query;
        BooleanClause firstBooleanClause = (BooleanClause)bq.clauses().get(0);
        Assert.assertFalse((boolean)firstBooleanClause.isScoring());
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-2037")
    public void testBooleanWithOnlyNegationQueries() throws Exception {
        QueryBuilder monthQb = this.helper.queryBuilder(Month.class);
        Query query = monthQb.bool().must(monthQb.keyword().onField("mythology").matching((Object)"colder").createQuery()).not().must(monthQb.keyword().onField("mythology").matching((Object)"snowboarding").createQuery()).not().createQuery();
        this.helper.assertThat(query).from(Month.class).matchesExactlyIds(Integer.valueOf(3));
        Assert.assertTrue((boolean)(query instanceof BooleanQuery));
        BooleanQuery bq = (BooleanQuery)query;
        BooleanClause firstBooleanClause = (BooleanClause)bq.clauses().get(0);
        Assert.assertFalse((boolean)firstBooleanClause.isScoring());
    }

    @Test(expected=SearchException.class)
    public void testIllegalBooleanJunction() {
        QueryBuilder monthQb = this.helper.queryBuilder(Month.class);
        BooleanJunction booleanJunction = monthQb.bool();
        Assert.assertTrue((boolean)booleanJunction.isEmpty());
        booleanJunction.createQuery();
        Assert.fail((String)"should not reach this point");
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-2565")
    public void testBooleanWithNullClauses() throws Exception {
        QueryBuilder monthQb = this.helper.queryBuilder(Month.class);
        Query query = monthQb.bool().must(null).must(monthQb.keyword().onField("mythology").matching((Object)"colder").createQuery()).should(null).createQuery();
        Assert.assertThat((Object)query, (Matcher)CoreMatchers.instanceOf(BooleanQuery.class));
        Assert.assertEquals((long)1L, (long)((BooleanQuery)query).clauses().size());
        this.helper.assertThat(query).from(Month.class).matchesExactlyIds(Integer.valueOf(1));
        query = monthQb.bool().must(null).not().must(null).disableScoring().must(monthQb.keyword().onField("mythology").matching((Object)"colder").createQuery()).createQuery();
        Assert.assertThat((Object)query, (Matcher)CoreMatchers.instanceOf(BooleanQuery.class));
        Assert.assertEquals((long)1L, (long)((BooleanQuery)query).clauses().size());
        this.helper.assertThat(query).from(Month.class).matchesExactlyIds(Integer.valueOf(1));
    }

    @Test
    public void testRangeQueryFromTo() throws Exception {
        QueryBuilder monthQb = this.helper.queryBuilder(Month.class);
        this.calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.calendar.set(1900, 2, 12, 0, 0, 0);
        this.calendar.set(14, 0);
        Date from = this.calendar.getTime();
        this.calendar.set(1910, 2, 12, 0, 0, 0);
        Date to = this.calendar.getTime();
        Query query = ((RangeMatchingContext)((RangeMatchingContext)monthQb.range().onField("estimatedCreation").andField("justfortest").ignoreFieldBridge()).ignoreAnalyzer()).from((Object)from).to((Object)to).excludeLimit().createQuery();
        this.helper.assertThat(query).from(Month.class).hasResultSize(1);
    }

    @Test
    @Category(value={SkipOnElasticsearch.class})
    public void testRangeQueryFromToIgnoreFieldBridge() throws Exception {
        QueryBuilder monthQb = this.helper.queryBuilder(Month.class);
        this.calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.calendar.set(1900, 2, 12, 0, 0, 0);
        this.calendar.set(14, 0);
        Date from = this.calendar.getTime();
        this.calendar.set(1910, 2, 12, 0, 0, 0);
        Date to = this.calendar.getTime();
        Query query = ((RangeMatchingContext)((RangeMatchingContext)((RangeMatchingContext)monthQb.range().onField("estimatedCreation").ignoreFieldBridge()).andField("justfortest").ignoreFieldBridge()).ignoreAnalyzer()).from((Object)DateTools.round((Date)from, (DateTools.Resolution)DateTools.Resolution.MINUTE)).to((Object)DateTools.round((Date)to, (DateTools.Resolution)DateTools.Resolution.MINUTE)).excludeLimit().createQuery();
        this.helper.assertThat(query).from(Month.class).hasResultSize(1);
    }

    @Test
    public void testRangeQueryBelow() throws Exception {
        QueryBuilder monthQb = this.helper.queryBuilder(Month.class);
        this.calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.calendar.set(1810, 2, 12, 0, 0, 0);
        Date to = this.calendar.getTime();
        Query query = ((RangeMatchingContext)((RangeMatchingContext)monthQb.range().onField("estimatedCreation").andField("justfortest").ignoreFieldBridge()).ignoreAnalyzer()).below((Object)to).createQuery();
        this.helper.assertThat(query).from(Month.class).matchesExactlyIds(Integer.valueOf(3));
        query = monthQb.range().onField("raindropInMm").below((Object)0.24).createQuery();
        Assert.assertTrue((boolean)query.getClass().isAssignableFrom(NumericRangeQuery.class));
        this.helper.assertThat(query).from(Month.class).matchesExactlyIds(Integer.valueOf(1));
    }

    @Test
    @Category(value={SkipOnElasticsearch.class})
    public void testRangeQueryBelowIgnoreFieldBridge() throws Exception {
        QueryBuilder monthQb = this.helper.queryBuilder(Month.class);
        this.calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.calendar.set(1810, 2, 12, 0, 0, 0);
        Date to = this.calendar.getTime();
        Query query = ((RangeMatchingContext)((RangeMatchingContext)((RangeMatchingContext)monthQb.range().onField("estimatedCreation").ignoreFieldBridge()).andField("justfortest").ignoreFieldBridge()).ignoreAnalyzer()).below((Object)DateTools.round((Date)to, (DateTools.Resolution)DateTools.Resolution.MINUTE)).createQuery();
        this.helper.assertThat(query).from(Month.class).matchesExactlyIds(Integer.valueOf(3));
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-2030")
    public void testRangeQueryWithNullToken() throws Exception {
        QueryBuilder monthQb = this.helper.queryBuilder(Month.class);
        Query query = monthQb.range().onField("keyForOrdering").below((Object)"-mar").createQuery();
        this.helper.assertThat(query).from(Month.class).matchesExactlyIds(Integer.valueOf(3));
        query = monthQb.range().onField("keyForOrdering").below(null).createQuery();
        this.helper.assertThat(query).from(Month.class).matchesExactlyIds(Integer.valueOf(3));
    }

    @Test
    public void testRangeQueryAbove() throws Exception {
        QueryBuilder monthQb = this.helper.queryBuilder(Month.class);
        this.calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.calendar.set(1910, 2, 12, 0, 0, 0);
        Date to = this.calendar.getTime();
        Query query = ((RangeMatchingContext)((RangeMatchingContext)monthQb.range().onField("estimatedCreation").andField("justfortest").ignoreFieldBridge()).ignoreAnalyzer()).above((Object)to).createQuery();
        this.helper.assertThat(query).from(Month.class).matchesExactlyIds(Integer.valueOf(2));
    }

    @Test
    @Category(value={SkipOnElasticsearch.class})
    public void testRangeQueryAboveIgnoreFieldBridge() throws Exception {
        QueryBuilder monthQb = this.helper.queryBuilder(Month.class);
        this.calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.calendar.set(1910, 2, 12, 0, 0, 0);
        Date to = this.calendar.getTime();
        Query query = ((RangeMatchingContext)((RangeMatchingContext)((RangeMatchingContext)monthQb.range().onField("estimatedCreation").ignoreFieldBridge()).andField("justfortest").ignoreFieldBridge()).ignoreAnalyzer()).above((Object)DateTools.round((Date)to, (DateTools.Resolution)DateTools.Resolution.MINUTE)).createQuery();
        this.helper.assertThat(query).from(Month.class).matchesExactlyIds(Integer.valueOf(2));
    }

    @Test
    public void testRangeQueryAboveInclusive() throws Exception {
        QueryBuilder monthQb = this.helper.queryBuilder(Month.class);
        Query query = ((RangeMatchingContext)((RangeMatchingContext)monthQb.range().onField("estimatedCreation").andField("justfortest").ignoreFieldBridge()).ignoreAnalyzer()).above((Object)this.february).createQuery();
        this.helper.assertThat(query).from(Month.class).matchesExactlyIds(Integer.valueOf(2));
    }

    @Test
    public void testRangeQueryAboveExclusive() throws Exception {
        QueryBuilder monthQb = this.helper.queryBuilder(Month.class);
        Query query = ((RangeMatchingContext)((RangeMatchingContext)monthQb.range().onField("estimatedCreation").andField("justfortest").ignoreFieldBridge()).ignoreAnalyzer()).above((Object)this.february).excludeLimit().createQuery();
        this.helper.assertThat(query).from(Month.class).matchesNone();
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-2656")
    public void testNumericRangeQueryWithFieldTypeOverriddenByFieldBridge() throws Exception {
        QueryBuilder monthQb = this.helper.queryBuilder(Month.class);
        Query query = ((RangeMatchingContext)((RangeMatchingContext)monthQb.range().onField("monthBase0").ignoreFieldBridge()).ignoreAnalyzer()).below((Object)1).excludeLimit().createQuery();
        this.helper.assertThat(query).from(Month.class).matchesUnorderedIds(Integer.valueOf(1));
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-2656")
    public void testNumericQueryWithFieldTypeOverriddenByFieldBridge() throws Exception {
        QueryBuilder monthQb = this.helper.queryBuilder(Month.class);
        Query query = ((TermMatchingContext)((TermMatchingContext)monthQb.keyword().onField("monthBase0").ignoreFieldBridge()).ignoreAnalyzer()).matching((Object)0).createQuery();
        this.helper.assertThat(query).from(Month.class).matchesUnorderedIds(Integer.valueOf(1));
    }

    @Test
    public void testPhraseQuery() throws Exception {
        QueryBuilder monthQb = this.helper.queryBuilder(Month.class);
        Query query = monthQb.phrase().onField("mythology").sentence("Month whitening").createQuery();
        this.helper.assertThat(query).from(Month.class).as("test slop").hasResultSize(0);
        query = monthQb.phrase().withSlop(3).onField("mythology").sentence("Month whitening").createQuery();
        this.helper.assertThat(query).from(Month.class).as("test slop").hasResultSize(1);
        query = monthQb.phrase().onField("mythology").sentence("whitening").createQuery();
        this.helper.assertThat(query).from(Month.class).as("test one term optimization").hasResultSize(1);
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-2785")
    public void testPhraseQueryWithNormalizer() throws Exception {
        QueryBuilder monthQb = this.helper.queryBuilder(Month.class);
        Query query = monthQb.phrase().onField("name").sentence("February").createQuery();
        this.helper.assertThat(query).from(Month.class).hasResultSize(1);
        query = monthQb.phrase().onField("name").sentence("february").createQuery();
        this.helper.assertThat(query).from(Month.class).hasResultSize(1);
        query = monthQb.phrase().onField("mythology_normalized").sentence("Month whitening").createQuery();
        this.helper.assertThat(query).from(Month.class).hasResultSize(0);
        query = monthQb.phrase().onField("mythology_normalized").sentence("month whitening").createQuery();
        this.helper.assertThat(query).from(Month.class).hasResultSize(0);
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-2479")
    public void testPhraseQueryTermCreation() throws Exception {
        String testCaseText = "Test the Test test of your test test to test test test of test and Test budgeting.";
        QueryBuilder monthQb = this.helper.queryBuilder(Month.class);
        Query query = monthQb.phrase().onField("mythology").sentence(testCaseText).createQuery();
        this.helper.assertThat(query).from(Month.class).as("test term ordering").hasResultSize(0);
    }

    @Test
    public void testPhraseQueryWithStopWords() throws Exception {
        QueryBuilder monthQb = this.helper.queryBuilder(Month.class);
        Query query = monthQb.phrase().onField("mythology").sentence("colder and whitening").createQuery();
        this.helper.assertThat(query).from(Month.class).hasResultSize(1);
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-1074")
    public void testPhraseQueryWithNoTermsAfterAnalyzerApplication() throws Exception {
        QueryBuilder monthQb = this.helper.queryBuilder(Month.class);
        Query query = monthQb.phrase().onField("mythology_stem").sentence("and").createQuery();
        this.helper.assertThat(query).from(Month.class).as("there should be no results, since all terms are stop words").matchesNone();
    }

    @Test
    public void testNumericRangeQueries() {
        QueryBuilder monthQb = this.helper.queryBuilder(Month.class);
        Query query = monthQb.range().onField("raindropInMm").from((Object)0.23).to((Object)0.24).createQuery();
        Assert.assertTrue((boolean)query.getClass().isAssignableFrom(NumericRangeQuery.class));
        this.helper.assertThat(query).from(Month.class).matchesExactlyIds(Integer.valueOf(1));
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-1378")
    public void testNumericRangeQueryAbove() {
        QueryBuilder monthQb = this.helper.queryBuilder(Month.class);
        Query query = monthQb.range().onField("raindropInMm").above((Object)0.231).createQuery();
        Assert.assertTrue((boolean)query.getClass().isAssignableFrom(NumericRangeQuery.class));
        this.helper.assertThat(query).from(Month.class).matchesUnorderedIds(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3));
        query = monthQb.range().onField("raindropInMm").above((Object)0.231).excludeLimit().createQuery();
        this.helper.assertThat(query).from(Month.class).matchesUnorderedIds(Integer.valueOf(2), Integer.valueOf(3));
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-1378")
    public void testNumericRangeQueryBelow() {
        QueryBuilder monthQb = this.helper.queryBuilder(Month.class);
        Query query = monthQb.range().onField("raindropInMm").below((Object)0.435).createQuery();
        Assert.assertTrue((boolean)query.getClass().isAssignableFrom(NumericRangeQuery.class));
        this.helper.assertThat(query).from(Month.class).matchesUnorderedIds(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3));
        query = monthQb.range().onField("raindropInMm").below((Object)0.435).excludeLimit().createQuery();
        this.helper.assertThat(query).from(Month.class).matchesUnorderedIds(Integer.valueOf(1));
    }

    @Test
    public void testNumericFieldsTermQuery() {
        QueryBuilder monthQb = this.helper.queryBuilder(Month.class);
        Query query = monthQb.keyword().onField("raindropInMm").matching((Object)0.231).createQuery();
        Assert.assertTrue((boolean)query.getClass().isAssignableFrom(NumericRangeQuery.class));
        this.helper.assertThat(query).from(Month.class).hasResultSize(1);
    }

    @Test
    public void testFieldBridge() {
        QueryBuilder monthQb = this.helper.queryBuilder(Month.class);
        Query query = monthQb.keyword().onField("monthRomanNumber").matching((Object)2).createQuery();
        this.helper.assertThat(query).from(Month.class).matchesExactlyIds(Integer.valueOf(2));
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-703")
    public void testPolymorphicQueryForUnindexedSuperTypeReturnsIndexedSubType() {
        QueryBuilder builder = this.helper.queryBuilder(Object.class);
        Query query = builder.all().createQuery();
        this.helper.assertThat(query).from(Object.class).as("expected all instances of all indexed types").hasResultSize(8);
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-703")
    public void testPolymorphicQueryWithKeywordTermForUnindexedSuperTypeReturnsIndexedSubType() {
        QueryBuilder builder = this.helper.queryBuilder(Car.class);
        Query query = builder.keyword().onField("name").matching((Object)"Morris").createQuery();
        this.helper.assertThat(query).matchesExactlyIds(Integer.valueOf(2));
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-703")
    public void testObtainingBuilderForUnindexedTypeWithoutIndexedSubTypesCausesException() {
        try {
            this.helper.queryBuilder(Animal.class);
            Assert.fail((String)"Obtaining a builder not allowed for unindexed type without any indexed sub-types.");
        }
        catch (SearchException searchException) {
            // empty catch block
        }
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-1791")
    public void testUsingMatchQueryOnNumericDocumentIdGeneratesTermQuery() throws Exception {
        QueryBuilder monthQb = this.helper.queryBuilder(Month.class);
        Query query = monthQb.keyword().onField("id").matching((Object)1).createQuery();
        Assert.assertTrue((String)("A string based TermQuery is expected, but got a " + query.getClass()), (boolean)(query instanceof TermQuery));
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-1791")
    public void testUsingRangeQueryOnNumericDocumentIdGeneratesTermRangeQuery() throws Exception {
        QueryBuilder monthQb = this.helper.queryBuilder(Month.class);
        Query query = monthQb.range().onField("id").from((Object)1).to((Object)3).createQuery();
        Assert.assertTrue((String)("A string based TermQuery is expected, but got a " + query.getClass()), (boolean)(query instanceof TermRangeQuery));
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-1791")
    public void testUsingMatchingQueryOnNumericFieldCreatesNumericRangeQuery() throws Exception {
        QueryBuilder monthQb = this.helper.queryBuilder(Day.class);
        Query query = monthQb.keyword().onField("idNumeric").matching((Object)2).createQuery();
        Assert.assertTrue((String)("A NumericRangeQuery is expected, but got a " + query.getClass()), (boolean)(query instanceof NumericRangeQuery));
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-1791")
    @Category(value={SkipOnElasticsearch.class})
    public void testUseMatchQueryOnEmbeddedNumericIdCreatesTermQuery() throws Exception {
        QueryBuilder coffeeQb = this.helper.queryBuilder(Coffee.class);
        Query query = coffeeQb.keyword().onField("brand.id").matching((Object)1).createQuery();
        Assert.assertTrue((String)("A TermQuery is expected, but got a " + query.getClass()), (boolean)(query instanceof TermQuery));
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-2199")
    public void testCharFilters() throws Exception {
        QueryBuilder monthQb = this.helper.queryBuilder(Month.class);
        Query query = monthQb.keyword().onField("htmlDescription").matching((Object)"strong").createQuery();
        this.helper.assertThat(query).from(Month.class).hasResultSize(2);
        query = monthQb.keyword().onField("htmlDescription").matching((Object)"em").createQuery();
        this.helper.assertThat(query).from(Month.class).hasResultSize(2);
        query = monthQb.keyword().onField("htmlDescription_htmlStrip").matching((Object)"strong").createQuery();
        this.helper.assertThat(query).from(Month.class).hasResultSize(0);
        query = monthQb.keyword().onField("htmlDescription_htmlStrip").matching((Object)"em").createQuery();
        this.helper.assertThat(query).from(Month.class).hasResultSize(0);
        query = monthQb.keyword().onField("htmlDescription_htmlStrip").matching((Object)"month").createQuery();
        this.helper.assertThat(query).from(Month.class).hasResultSize(3);
        query = monthQb.keyword().onField("htmlDescription_htmlStrip").matching((Object)"spring").createQuery();
        this.helper.assertThat(query).from(Month.class).hasResultSize(1);
        query = monthQb.keyword().onField("htmlDescription_htmlStrip").matching((Object)"fake").createQuery();
        this.helper.assertThat(query).from(Month.class).hasResultSize(1);
        query = monthQb.keyword().onField("htmlDescription_htmlStrip").matching((Object)"escaped").createQuery();
        this.helper.assertThat(query).from(Month.class).hasResultSize(1);
    }

    private void indexTestData() {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.ROOT);
        calendar.set(1900, 2, 12, 0, 0, 0);
        calendar.set(14, 0);
        Date january = calendar.getTime();
        this.helper.add(new Month("January", 1, "Month of colder and whitening", "Historically colder than any other month in the northern hemisphere", january, 0.231, "jan", "<escaped>Month</escaped> of <em>colder</em> and <strong>whitening</strong>"));
        calendar.set(2000, 2, 12, 0, 0, 0);
        this.february = calendar.getTime();
        this.helper.add(new Month("February", 2, "Month of snowboarding", "Historically, the month where we make babies while watching the whitening landscape", this.february, 0.435, "feb", "Month of <em>snowboarding</em>"));
        calendar.set(1800, 2, 12, 0, 0, 0);
        Date march = calendar.getTime();
        this.helper.add(new Month("March", 3, "Month of fake spring", "Historically, the month in which we actually find time to go snowboarding.", march, 0.435, "-mar", "Month of <strong>fake</strong> spring"));
        SportsCar car = new SportsCar(1, "Leyland", 100);
        this.helper.add(car);
        car = new SportsCar(2, "Morris", 180);
        this.helper.add(car);
        Day day = new Day(1, 1);
        this.helper.add(day);
        day = new Day(2, 2);
        this.helper.add(day);
        CoffeeBrand brand = new CoffeeBrand();
        brand.setId(0);
        brand.setName("Tasty, Inc.");
        Coffee coffee = new Coffee();
        coffee.setId("Peruvian Gold");
        coffee.setName("Peruvian Gold");
        coffee.setBrand(brand);
        this.helper.add(coffee);
    }

    public static class MappingFactory {
        @Factory
        public SearchMapping build() {
            SearchMapping mapping = new SearchMapping();
            mapping.analyzerDef("stemmer", StandardTokenizerFactory.class).filter(StandardFilterFactory.class).filter(LowerCaseFilterFactory.class).filter(StopFilterFactory.class).filter(SnowballPorterFilterFactory.class).param("language", "English").analyzerDef("ngram", StandardTokenizerFactory.class).filter(StandardFilterFactory.class).filter(LowerCaseFilterFactory.class).filter(StopFilterFactory.class).filter(NGramFilterFactory.class).param("minGramSize", "3").param("maxGramSize", "3").analyzerDef("htmlStrip", StandardTokenizerFactory.class).charFilter(HTMLStripCharFilterFactory.class).param("escapedTags", "escaped").filter(LowerCaseFilterFactory.class).normalizerDef("lower").filter(LowerCaseFilterFactory.class);
            return mapping;
        }
    }
}

