/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.errorhandling;

import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.exception.ErrorContext;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.junit.SearchIntegratorResource;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-1624")
public class ErrorHandlerGivenAsInstanceTest {
    @Rule
    public SearchIntegratorResource integratorResource = new SearchIntegratorResource();

    @Test
    public void canPassErrorHandlerInstanceToConfiguration() {
        MyErrorHandler errorHandler = new MyErrorHandler();
        SearchConfiguration cfg = this.getSearchConfiguration(errorHandler);
        ExtendedSearchIntegrator searchIntegrator = this.integratorResource.create(cfg);
        Assert.assertSame((Object)errorHandler, (Object)searchIntegrator.getErrorHandler());
    }

    private SearchConfiguration getSearchConfiguration(ErrorHandler errorHandler) {
        SearchConfigurationForTest cfg = new SearchConfigurationForTest();
        cfg.getProperties().put("hibernate.search.error_handler", errorHandler);
        return cfg;
    }

    private static class MyErrorHandler
    implements ErrorHandler {
        private MyErrorHandler() {
        }

        public void handle(ErrorContext context) {
        }

        public void handleException(String errorMsg, Throwable exception) {
        }
    }
}

