/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.filters;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.CompositeReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.BytesRef;
import org.fest.assertions.Assertions;
import org.fest.assertions.ListAssert;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.test.filters.ForwardingWeight;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.junit.SearchITHelper;
import org.hibernate.search.testsupport.junit.SkipOnElasticsearch;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@TestForIssue(jiraKey="HSEARCH-1230")
@Category(value={SkipOnElasticsearch.class})
public class FreshReadersProvidedTest {
    @Rule
    public final SearchFactoryHolder sfHolder = new SearchFactoryHolder(Guest.class);
    private final SearchITHelper helper = new SearchITHelper(this.sfHolder);

    @Test
    public void filtersTest() {
        ExtendedSearchIntegrator searchFactory = this.sfHolder.getSearchFactory();
        Assert.assertNotNull((Object)searchFactory.getIndexManagerHolder().getIndexManager("guests"));
        Guest lastDwarf = new Guest();
        lastDwarf.id = 13L;
        lastDwarf.name = "Thorin Oakenshield";
        this.helper.add(lastDwarf);
        QueryBuilder guestQueryBuilder = this.helper.queryBuilder(Guest.class);
        Query queryAllGuests = guestQueryBuilder.all().createQuery();
        this.helper.assertThat(queryAllGuests).from(Guest.class).matchesExactlyIds(Long.valueOf(13L));
        RecordingQueryWrapper recordingWrapper = new RecordingQueryWrapper(queryAllGuests, "name");
        this.helper.assertThat(recordingWrapper).from(Guest.class).matchesExactlyIds(Long.valueOf(13L));
        this.checkQueryInspectedAllSegments(recordingWrapper);
        this.expectedTermsForQuery(recordingWrapper, "thorin", "oakenshield");
        Guest balin = new Guest();
        balin.id = 7L;
        balin.name = "Balin";
        this.helper.add(balin);
        this.helper.assertThat(queryAllGuests).from(Guest.class).matchesExactlyIds(Long.valueOf(13L), Long.valueOf(7L));
        RecordingQueryWrapper secondRecordingWrapper = new RecordingQueryWrapper(queryAllGuests, "name");
        this.helper.assertThat(secondRecordingWrapper).from(Guest.class).matchesExactlyIds(Long.valueOf(13L), Long.valueOf(7L));
        this.checkQueryInspectedAllSegments(secondRecordingWrapper);
        this.expectedTermsForQuery(secondRecordingWrapper, "thorin", "oakenshield", "balin");
    }

    private void expectedTermsForQuery(RecordingQueryWrapper recordingWrapper, String ... term) {
        Assert.assertEquals((long)term.length, (long)recordingWrapper.seenTerms.size());
        ((ListAssert)Assertions.assertThat(recordingWrapper.seenTerms).as("seen terms")).contains((Object[])term);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkQueryInspectedAllSegments(RecordingQueryWrapper recordingWrapper) {
        ExtendedSearchIntegrator searchFactory = this.sfHolder.getSearchFactory();
        IndexReader currentIndexReader = searchFactory.getIndexReaderAccessor().open(new Class[]{Guest.class});
        try {
            List<IndexReader> allSubReaders = FreshReadersProvidedTest.getSubIndexReaders((MultiReader)currentIndexReader);
            ((ListAssert)Assertions.assertThat(recordingWrapper.visitedReaders).as("visited readers")).contains(allSubReaders.toArray());
        }
        finally {
            searchFactory.getIndexReaderAccessor().close(currentIndexReader);
        }
    }

    public static List<IndexReader> getSubIndexReaders(MultiReader compositeReader) {
        CompositeReaderContext compositeReaderContext = compositeReader.getContext();
        ArrayList<IndexReader> segmentReaders = new ArrayList<IndexReader>(20);
        for (LeafReaderContext readerContext : compositeReaderContext.leaves()) {
            segmentReaders.add((IndexReader)readerContext.reader());
        }
        return segmentReaders;
    }

    @Indexed(index="guests")
    public static final class Guest {
        private long id;
        private String name;

        @DocumentId
        public long getId() {
            return this.id;
        }

        public void setId(long id) {
            this.id = id;
        }

        @Field
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    private static class RecordingQueryWrapper
    extends Query {
        final Query delegate;
        final List<IndexReader> visitedReaders = new ArrayList<IndexReader>();
        final List<String> seenTerms = new ArrayList<String>();
        final String fieldName;

        public RecordingQueryWrapper(Query delegate, String fieldName) {
            this.delegate = delegate;
            this.fieldName = fieldName;
        }

        public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
            Weight delegateWeight = this.delegate.createWeight(searcher, needsScores);
            return new ForwardingWeight(this, delegateWeight){

                @Override
                public Scorer scorer(LeafReaderContext context) throws IOException {
                    this.record(context);
                    return super.scorer(context);
                }

                @Override
                public BulkScorer bulkScorer(LeafReaderContext context) throws IOException {
                    this.record(context);
                    return super.bulkScorer(context);
                }
            };
        }

        private void record(LeafReaderContext context) throws IOException {
            LeafReader reader = context.reader();
            this.visitedReaders.add((IndexReader)reader);
            Terms terms = reader.terms(this.fieldName);
            TermsEnum iterator = terms.iterator();
            BytesRef next = iterator.next();
            while (next != null) {
                this.seenTerms.add(next.utf8ToString());
                next = iterator.next();
            }
        }

        public String toString(String fieldName) {
            return "RecordingQueryWrapper(" + this.delegate + ", " + this.fieldName + ")";
        }
    }
}

