/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.testsupport.concurrency;

import java.util.concurrent.TimeUnit;
import junit.framework.AssertionFailedError;

public final class Poller {
    private final long timeoutValueNanos;
    private final long stepValueNanos;

    public static Poller milliseconds(long timeoutMs, long stepMs) {
        return Poller.create(timeoutMs, stepMs, TimeUnit.MILLISECONDS);
    }

    public static Poller nanoseconds(long timeoutNanos, long stepNanos) {
        return Poller.create(timeoutNanos, stepNanos, TimeUnit.NANOSECONDS);
    }

    private static Poller create(long timeoutValue, long stepValue, TimeUnit timeUnit) {
        return new Poller(timeUnit.toNanos(timeoutValue), timeUnit.toNanos(stepValue));
    }

    private Poller(long timeoutValueNanos, long stepValueNanos) {
        this.timeoutValueNanos = timeoutValueNanos;
        this.stepValueNanos = stepValueNanos;
    }

    public <E extends Exception> void pollAssertion(ThrowingRunnable<E> runnable) throws E {
        long initialNanoTime = System.nanoTime();
        long deadline = initialNanoTime + this.timeoutValueNanos;
        int nbOfFailedAttempts = 0;
        while (true) {
            this.sleepStep();
            try {
                runnable.run();
                return;
            }
            catch (AssertionError e) {
                AssertionError assertionError = e;
                ++nbOfFailedAttempts;
                if (System.nanoTime() < deadline) continue;
                long timeSpentNanos = System.nanoTime() - initialNanoTime;
                throw this.newAssertionPollingError(assertionError, nbOfFailedAttempts, timeSpentNanos);
            }
            break;
        }
    }

    private void sleepStep() {
        try {
            TimeUnit.NANOSECONDS.sleep(this.stepValueNanos);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Interrupted while waiting for an assertion to pass.", e);
        }
    }

    private AssertionError newAssertionPollingError(AssertionError lastAssertionError, int nbOfFailedAttempts, long timeSpentNanos) {
        AssertionFailedError error = new AssertionFailedError("Assertion failed even after " + nbOfFailedAttempts + " attempts in " + timeSpentNanos + "ns : " + ((Throwable)((Object)lastAssertionError)).getMessage());
        error.initCause((Throwable)((Object)lastAssertionError));
        return error;
    }

    public static interface ThrowingRunnable<E extends Exception> {
        public void run() throws E;
    }
}

