/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.dsl;

import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.junit.SearchITHelper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-1973")
public class NumericTypeWithNullEncodingTest {
    @Rule
    public final SearchFactoryHolder sfHolder = new SearchFactoryHolder(SomeEntity.class).withProperty("hibernate.search.default_null_token", "-7");
    private final SearchITHelper helper = new SearchITHelper(this.sfHolder);

    @Before
    public void prepareTestData() {
        this.storeData("title-one", 1, 1);
        this.storeData("title-two", 2, null);
        this.storeData("title-three", 3, 3);
    }

    @Test
    public void verifyExplicitRangeQuery() {
        Query query = this.getQueryBuilder().range().onField("age").from((Object)1).excludeLimit().to((Object)3).excludeLimit().createQuery();
        Assert.assertTrue((boolean)(query instanceof NumericRangeQuery));
        this.assertProjection(query, "title").matchesExactlySingleProjections("title-two");
    }

    @Test
    public void verifyExplicitKeywordQuery() {
        Query query = this.getQueryBuilder().keyword().onField("age").matching((Object)2).createQuery();
        Assert.assertTrue((boolean)(query instanceof NumericRangeQuery));
        this.assertProjection(query, "title").matchesExactlySingleProjections("title-two");
    }

    @Test
    public void verifyCustomNullEncoding() {
        Query query = this.getQueryBuilder().keyword().onField("nullableAge").matching(null).createQuery();
        Assert.assertTrue((boolean)(query instanceof NumericRangeQuery));
        Assert.assertEquals((Object)"[-1 TO -1]", (Object)query.toString("nullableAge"));
        this.assertProjection(query, "title").matchesExactlySingleProjections("title-two");
    }

    @Test
    public void verifyNullEncoding() {
        Query query = this.getQueryBuilder().keyword().onField("age").matching(null).createQuery();
        Assert.assertTrue((boolean)(query instanceof NumericRangeQuery));
        Assert.assertEquals((Object)"[-7 TO -7]", (Object)query.toString("age"));
        this.assertProjection(query, "title").matchesNone();
    }

    private SearchITHelper.AssertBuildingHSQueryContext assertProjection(Query query, String fieldName) {
        return this.helper.assertThat(query).from(SomeEntity.class).projecting(fieldName);
    }

    private QueryBuilder getQueryBuilder() {
        return this.helper.queryBuilder(SomeEntity.class);
    }

    private void storeData(String title, int value, Integer nullableAge) {
        SomeEntity entry = new SomeEntity();
        entry.title = title;
        entry.age = value;
        entry.nullableAge = nullableAge;
        this.helper.add(entry);
    }

    @Indexed
    public static class SomeEntity {
        @DocumentId
        String title;
        @Field(indexNullAs="__DEFAULT_NULL_TOKEN__")
        int age;
        @Field(indexNullAs="-1")
        Integer nullableAge;
    }
}

