/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.analyzer.common;

import java.util.Set;
import org.apache.lucene.analysis.core.LowerCaseFilterFactory;
import org.apache.lucene.analysis.de.GermanStemFilterFactory;
import org.apache.lucene.analysis.snowball.SnowballPorterFilterFactory;
import org.apache.lucene.analysis.standard.StandardTokenizerFactory;
import org.hibernate.search.annotations.AnalyzerDef;
import org.hibernate.search.annotations.AnalyzerDefs;
import org.hibernate.search.annotations.AnalyzerDiscriminator;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.Parameter;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.annotations.TokenFilterDef;
import org.hibernate.search.annotations.TokenizerDef;
import org.hibernate.search.test.analyzer.common.LanguageDiscriminator;

@Indexed
@AnalyzerDefs(value={@AnalyzerDef(name="en", tokenizer=@TokenizerDef(factory=StandardTokenizerFactory.class), filters={@TokenFilterDef(factory=LowerCaseFilterFactory.class), @TokenFilterDef(factory=SnowballPorterFilterFactory.class, params={@Parameter(name="language", value="English")})}), @AnalyzerDef(name="de", tokenizer=@TokenizerDef(factory=StandardTokenizerFactory.class), filters={@TokenFilterDef(factory=LowerCaseFilterFactory.class), @TokenFilterDef(factory=GermanStemFilterFactory.class)})})
public class Article {
    private Integer id;
    private String language;
    private String text;
    private Set<Article> references;

    @DocumentId
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @Field(store=Store.YES)
    @AnalyzerDiscriminator(impl=LanguageDiscriminator.class)
    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    @Field(store=Store.YES)
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    @IndexedEmbedded(depth=1)
    public Set<Article> getReferences() {
        return this.references;
    }

    public void setReferences(Set<Article> references) {
        this.references = references;
    }
}

