/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.bridge.time;

import java.time.Instant;
import org.assertj.core.api.Assertions;
import org.hibernate.search.bridge.builtin.time.impl.InstantBridge;
import org.hibernate.search.exception.SearchException;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class InstantBridgeTest {
    private static final InstantBridge BRIDGE = InstantBridge.INSTANCE;
    private static final Instant MAX_INSTANT = Instant.ofEpochMilli(Long.MAX_VALUE);
    private static final Instant CUSTOM_INSTANT = Instant.ofEpochSecond(12345L, 1L);
    @Rule
    public final ExpectedException thrown = ExpectedException.none();

    @Test
    public void testMaxObjectToString() throws Exception {
        Assertions.assertThat((String)BRIDGE.objectToString((Object)MAX_INSTANT)).isEqualTo((Object)String.valueOf(MAX_INSTANT.toEpochMilli()));
    }

    @Test
    public void testPaddingObjectToString() throws Exception {
        Assertions.assertThat((String)BRIDGE.objectToString((Object)CUSTOM_INSTANT)).isEqualTo((Object)String.valueOf(CUSTOM_INSTANT.toEpochMilli()));
    }

    @Test
    public void testTooLargeValueException() {
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage("HSEARCH000297");
        BRIDGE.objectToString((Object)Instant.MAX);
    }
}

