/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.spi.impl;

import java.io.Serializable;
import java.util.Objects;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.IndexedTypeSet;
import org.hibernate.search.spi.impl.HashSetIndexedTypeSet;

public final class PojoIndexedTypeIdentifier
implements IndexedTypeIdentifier,
Serializable {
    private final Class<?> pojoType;

    public PojoIndexedTypeIdentifier(Class<?> pojoType) {
        Objects.requireNonNull(pojoType);
        this.pojoType = pojoType;
    }

    @Override
    public String getName() {
        return this.pojoType.getName();
    }

    @Override
    public Class<?> getPojoType() {
        return this.pojoType;
    }

    @Override
    public IndexedTypeSet asTypeSet() {
        return new HashSetIndexedTypeSet(this);
    }

    public int hashCode() {
        return this.pojoType.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        assert (PojoIndexedTypeIdentifier.class == obj.getClass()) : "This should never happen. If it happens, you're mixing types in the same Map and that's a bug";
        PojoIndexedTypeIdentifier other = (PojoIndexedTypeIdentifier)obj;
        return this.pojoType.equals(other.pojoType);
    }

    public String toString() {
        return this.getName();
    }

    public static IndexedTypeIdentifier convertFromLegacy(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        return new PojoIndexedTypeIdentifier(clazz);
    }

    public static Class<?> convertToLegacy(IndexedTypeIdentifier type) {
        if (type == null) {
            return null;
        }
        return ((PojoIndexedTypeIdentifier)type).pojoType;
    }
}

