/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.util.impl;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.search.similarities.ClassicSimilarity;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.Version;
import org.hibernate.search.cfg.Environment;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.indexes.spi.DirectoryBasedIndexManager;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.testsupport.analyzer.BarAnalyzer;
import org.hibernate.search.testsupport.analyzer.FooAnalyzer;
import org.hibernate.search.util.impl.ClassLoaderHelper;
import org.junit.Assert;
import org.junit.Test;

public class ClassLoaderHelperTest {
    @Test
    public void testInstanceFromClass() {
        IndexManager batchBackend = (IndexManager)ClassLoaderHelper.instanceFromClass(IndexManager.class, DirectoryBasedIndexManager.class, (String)"Lucene index manager");
        Assert.assertNotNull((Object)batchBackend);
        Assert.assertTrue((boolean)batchBackend.getClass().equals(DirectoryBasedIndexManager.class));
        Similarity sim = (Similarity)ClassLoaderHelper.instanceFromClass(Similarity.class, ClassicSimilarity.class, (String)"default similarity");
        Assert.assertNotNull((Object)sim);
        Assert.assertTrue((boolean)sim.getClass().equals(ClassicSimilarity.class));
        this.wrappingTestFromClass("Wrong configuration of Lucene index manager: class org.hibernate.search.test.util.impl.ClassLoaderHelperTest does not implement interface org.hibernate.search.indexes.spi.IndexManager", IndexManager.class, ClassLoaderHelperTest.class, "Lucene index manager");
        this.wrappingTestFromClass("Wrong configuration of default similarity: class org.hibernate.search.indexes.spi.DirectoryBasedIndexManager is not a subtype of org.apache.lucene.search.similarities.Similarity", Similarity.class, DirectoryBasedIndexManager.class, "default similarity");
        this.wrappingTestFromClass("Unable to instantiate default similarity class: 'org.apache.lucene.search.similarities.Similarity'. Class or constructor is not accessible.", Similarity.class, Similarity.class, "default similarity");
    }

    @Test
    public void testLoadingAnalyzerWithVersionConstructor() {
        Analyzer analyzer = ClassLoaderHelper.analyzerInstanceFromClass(StandardAnalyzer.class, (Version)Environment.DEFAULT_LUCENE_MATCH_VERSION);
        Assert.assertNotNull((String)"We should be able to instantiate an analyzer with a Lucene version parameter", (Object)analyzer);
    }

    @Test
    public void testLoadingAnalyzerWithDefaultConstructor() {
        Analyzer analyzer = ClassLoaderHelper.analyzerInstanceFromClass(FooAnalyzer.class, (Version)Environment.DEFAULT_LUCENE_MATCH_VERSION);
        Assert.assertNotNull((String)"We should be able to instantiate an analyzer which has only a default constructor", (Object)analyzer);
    }

    @Test
    public void testLoadingAnalyzerWithNoVersionOrDefaultConstructor() {
        try {
            ClassLoaderHelper.analyzerInstanceFromClass(BarAnalyzer.class, (Version)Environment.DEFAULT_LUCENE_MATCH_VERSION);
            Assert.fail((String)"We should not be able to instantiate a analyzer with no default constructor or simple Version parameter.");
        }
        catch (SearchException e) {
            Assert.assertEquals(((Object)((Object)e)).getClass(), SearchException.class);
            Assert.assertEquals((Object)"Unable to instantiate analyzer class: org.hibernate.search.testsupport.analyzer.BarAnalyzer. Class neither has a default constructor nor a constructor with a Version parameter", (Object)e.getMessage());
        }
    }

    private void wrappingTestFromClass(String expectedErrorMessage, Class<?> interf, Class<?> impl, String componentName) {
        try {
            ClassLoaderHelper.instanceFromClass(interf, impl, (String)componentName);
            Assert.fail((String)"was expecting a SearchException");
        }
        catch (Exception e) {
            Assert.assertEquals(e.getClass(), SearchException.class);
            Assert.assertEquals((Object)expectedErrorMessage, (Object)e.getMessage());
        }
    }
}

