/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration;

import java.io.Serializable;
import java.lang.annotation.ElementType;
import org.apache.lucene.search.Query;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.dsl.TermMatchingContext;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.testsupport.junit.SearchITHelper;
import org.hibernate.search.testsupport.junit.SearchIntegratorResource;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ImplicitProvidedIdTest {
    @Rule
    public final SearchIntegratorResource integratorResource = new SearchIntegratorResource();
    @Rule
    public final ExpectedException exceptions = ExpectedException.none();
    private SearchIntegrator searchIntegrator;
    private final SearchITHelper helper = new SearchITHelper(() -> this.searchIntegrator);

    @Test
    public void exceptionThrownWhenNotEnabled() {
        SearchMapping mapping = new SearchMapping();
        mapping.entity(Book.class).indexed().property("title", ElementType.FIELD).field().property("text", ElementType.FIELD).field();
        SearchConfigurationForTest cfg = new SearchConfigurationForTest().setProgrammaticMapping(mapping).addClass(Book.class);
        this.exceptions.expect(SearchException.class);
        this.exceptions.expectMessage("HSEARCH000177");
        this.storeBooksViaProvidedId(cfg, "providedId", false);
    }

    @Test
    public void usingConfigurationTypeOverride() {
        SearchMapping mapping = new SearchMapping();
        mapping.entity(Book.class).indexed().property("title", ElementType.FIELD).field().property("text", ElementType.FIELD).field();
        SearchConfigurationForTest cfg = new SearchConfigurationForTest().setProgrammaticMapping(mapping).setIdProvidedImplicit(true).addClass(Book.class);
        this.storeBooksViaProvidedId(cfg, "providedId", false);
    }

    @Test
    public void usingProvidedIdAsOptionsOverride() {
        SearchMapping mapping = new SearchMapping();
        mapping.entity(Book.class).indexed().providedId().name("myID").property("title", ElementType.FIELD).field().property("text", ElementType.FIELD).field();
        SearchConfigurationForTest cfg = new SearchConfigurationForTest().setProgrammaticMapping(mapping).setIdProvidedImplicit(true).addClass(Book.class);
        this.storeBooksViaProvidedId(cfg, "myID", false);
    }

    @Test
    public void usingExplicitProvidedId() {
        SearchMapping mapping = new SearchMapping();
        mapping.entity(Book.class).indexed().providedId().name("myID").property("title", ElementType.FIELD).field().property("text", ElementType.FIELD).field();
        SearchConfigurationForTest cfg = new SearchConfigurationForTest().setProgrammaticMapping(mapping).setIdProvidedImplicit(false).addClass(Book.class);
        this.storeBooksViaProvidedId(cfg, "myID", false);
    }

    @Test
    public void usingDefaultSettings() {
        SearchMapping mapping = new SearchMapping();
        mapping.entity(Book.class).indexed().providedId().name("myID").property("title", ElementType.FIELD).field().property("text", ElementType.FIELD).field();
        SearchConfigurationForTest cfg = new SearchConfigurationForTest().setProgrammaticMapping(mapping).addClass(Book.class);
        this.storeBooksViaProvidedId(cfg, "myID", false);
    }

    @Test
    public void documentIdNotOverriden() {
        SearchMapping mapping = new SearchMapping();
        mapping.entity(Book.class).indexed().property("title", ElementType.FIELD).documentId().property("text", ElementType.FIELD).field();
        SearchConfigurationForTest cfg = new SearchConfigurationForTest().setProgrammaticMapping(mapping).addClass(Book.class);
        this.storeBooksViaProvidedId(cfg, "title", true);
    }

    private void storeBooksViaProvidedId(SearchConfigurationForTest cfg, String fieldName, boolean matchTitle) {
        this.searchIntegrator = this.integratorResource.create(cfg);
        Book book = new Book();
        book.title = "Less is nice";
        book.text = "When using Infinispan Query, users have to always remember to add @ProvidedId on their classes or a nasty exception will remind them. Can't we just assume it's always annotated?";
        String isbn = "some entity-external id";
        this.helper.add((Object)book, (Serializable)((Object)isbn));
        QueryBuilder queryBuilder = this.helper.queryBuilder(Book.class);
        Query query = ((TermMatchingContext)queryBuilder.keyword().onField(fieldName).ignoreAnalyzer()).matching((Object)(matchTitle ? book.title : isbn)).createQuery();
        this.helper.assertThat(query).from(Book.class).hasResultSize(1);
    }

    static class Book {
        String title;
        String text;

        Book() {
        }
    }
}

