/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration;

import java.io.Serializable;
import org.assertj.core.api.Assertions;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.junit.SearchITHelper;
import org.hibernate.search.testsupport.junit.SearchIntegratorResource;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.junit.Rule;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-2531")
public class IndexNameOverrideTest {
    public static final String INDEXED_ANNOTATION_OVERRIDDEN_INDEX_NAME = "indexed_annotation_overridden_index_name";
    public static final String CONFIGURATION_OVERRIDDEN_INDEX_NAME = "configuration_overridden_index_name";
    @Rule
    public final SearchIntegratorResource integratorResource = new SearchIntegratorResource();
    private SearchIntegrator integrator;
    private final SearchITHelper helper = new SearchITHelper(() -> this.integrator);

    @Test
    public void noOverride() throws Exception {
        SearchConfigurationForTest cfg = new SearchConfigurationForTest();
        cfg.addClass(NoAnnotationIndexNameOverrideEntity.class);
        this.integrator = this.init(cfg);
        Assertions.assertThat((Iterable)((EntityIndexBinding)this.integrator.getIndexBindings().get(NoAnnotationIndexNameOverrideEntity.class)).getIndexManagerSelector().all()).extracting("indexName").as("Index names for entity " + NoAnnotationIndexNameOverrideEntity.class, new Object[0]).containsOnly(new Object[]{NoAnnotationIndexNameOverrideEntity.class.getName()});
        NoAnnotationIndexNameOverrideEntity entity = new NoAnnotationIndexNameOverrideEntity();
        entity.id = 1L;
        this.assertIndexingWorksProperly(entity, Long.valueOf(entity.id));
    }

    @Test
    public void annotationOverride() throws Exception {
        SearchConfigurationForTest cfg = new SearchConfigurationForTest();
        cfg.addClass(IndexedAnnotationIndexNameOverriddeEntity.class);
        this.integrator = this.init(cfg);
        Assertions.assertThat((Iterable)((EntityIndexBinding)this.integrator.getIndexBindings().get(IndexedAnnotationIndexNameOverriddeEntity.class)).getIndexManagerSelector().all()).extracting("indexName").as("Index names for entity " + IndexedAnnotationIndexNameOverriddeEntity.class, new Object[0]).containsOnly(new Object[]{INDEXED_ANNOTATION_OVERRIDDEN_INDEX_NAME});
        IndexedAnnotationIndexNameOverriddeEntity entity = new IndexedAnnotationIndexNameOverriddeEntity();
        entity.id = 1L;
        this.assertIndexingWorksProperly(entity, Long.valueOf(entity.id));
    }

    @Test
    public void configurationOverride() throws Exception {
        SearchConfigurationForTest cfg = new SearchConfigurationForTest();
        cfg.addClass(NoAnnotationIndexNameOverrideEntity.class);
        cfg.addProperty("hibernate.search." + NoAnnotationIndexNameOverrideEntity.class.getName() + "." + "indexName", CONFIGURATION_OVERRIDDEN_INDEX_NAME);
        this.integrator = this.init(cfg);
        Assertions.assertThat((Iterable)((EntityIndexBinding)this.integrator.getIndexBindings().get(NoAnnotationIndexNameOverrideEntity.class)).getIndexManagerSelector().all()).extracting("indexName").as("Index names for entity " + NoAnnotationIndexNameOverrideEntity.class, new Object[0]).containsOnly(new Object[]{NoAnnotationIndexNameOverrideEntity.class.getName()});
        NoAnnotationIndexNameOverrideEntity entity = new NoAnnotationIndexNameOverrideEntity();
        entity.id = 1L;
        this.assertIndexingWorksProperly(entity, Long.valueOf(entity.id));
    }

    @Test
    public void configurationAndAnnotationOverride() throws Exception {
        SearchConfigurationForTest cfg = new SearchConfigurationForTest();
        cfg.addClass(IndexedAnnotationIndexNameOverriddeEntity.class);
        cfg.addProperty("hibernate.search." + IndexedAnnotationIndexNameOverriddeEntity.class.getName() + "." + "indexName", CONFIGURATION_OVERRIDDEN_INDEX_NAME);
        this.integrator = this.init(cfg);
        Assertions.assertThat((Iterable)((EntityIndexBinding)this.integrator.getIndexBindings().get(IndexedAnnotationIndexNameOverriddeEntity.class)).getIndexManagerSelector().all()).extracting("indexName").as("Index names for entity " + IndexedAnnotationIndexNameOverriddeEntity.class, new Object[0]).containsOnly(new Object[]{INDEXED_ANNOTATION_OVERRIDDEN_INDEX_NAME});
        IndexedAnnotationIndexNameOverriddeEntity entity = new IndexedAnnotationIndexNameOverriddeEntity();
        entity.id = 1L;
        this.assertIndexingWorksProperly(entity, Long.valueOf(entity.id));
    }

    private SearchIntegrator init(SearchConfigurationForTest cfg) {
        return this.integratorResource.create(cfg);
    }

    private void assertIndexingWorksProperly(Object entity, Serializable id) {
        this.helper.add(entity);
        this.helper.assertThat().from(entity.getClass()).matchesExactlyIds(id);
    }

    @Indexed
    public static final class NoAnnotationIndexNameOverrideEntity {
        @DocumentId
        private long id;
        @Field
        private String field;
    }

    @Indexed(index="indexed_annotation_overridden_index_name")
    public static final class IndexedAnnotationIndexNameOverriddeEntity {
        @DocumentId
        private long id;
        @Field
        private String field;
    }
}

