/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.indexmanager;

import java.io.IOException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.Lock;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.indexes.spi.DirectoryBasedIndexManager;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.test.indexmanager.Entity;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.junit.SearchITHelper;
import org.hibernate.search.testsupport.junit.SkipOnElasticsearch;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@TestForIssue(jiraKey="HSEARCH-2012")
@Category(value={SkipOnElasticsearch.class})
public class DirectoryBasedIndexManagerTest {
    @Rule
    public final SearchFactoryHolder sfh = new SearchFactoryHolder(Entity.class);
    private final SearchITHelper helper = new SearchITHelper(this.sfh);

    @Test
    public void testUnlockIndexWriter() throws Exception {
        ExtendedSearchIntegrator searchIntegrator = this.sfh.getSearchFactory();
        IndexManager indexManager = (IndexManager)((EntityIndexBinding)searchIntegrator.getIndexBindings().get(Entity.class)).getIndexManagerSelector().all().iterator().next();
        this.helper.add((Object)new Entity(), Integer.valueOf(1));
        Assert.assertTrue((boolean)this.isIndexWriterLocked(indexManager));
        indexManager.flushAndReleaseResources();
        Assert.assertFalse((boolean)this.isIndexWriterLocked(indexManager));
        this.helper.add((Object)new Entity(), Integer.valueOf(2));
        Assert.assertTrue((boolean)this.isIndexWriterLocked(indexManager));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isIndexWriterLocked(IndexManager indexManager) {
        Directory directory = ((DirectoryBasedIndexManager)indexManager).getDirectoryProvider().getDirectory();
        Lock lock = null;
        try {
            lock = directory.obtainLock("write.lock");
        }
        catch (IOException e) {
            boolean bl = true;
            return bl;
        }
        finally {
            if (lock != null) {
                try {
                    lock.close();
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }
}

