/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.bridge.builtin;

import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.TikaMetadataProcessor;
import org.hibernate.search.bridge.TikaParseContextProvider;
import org.hibernate.search.bridge.TikaParserProvider;
import org.hibernate.search.bridge.builtin.TikaBridge;
import org.hibernate.search.engine.impl.LuceneOptionsImpl;
import org.hibernate.search.engine.metadata.impl.BackReference;
import org.hibernate.search.engine.metadata.impl.DocumentFieldMetadata;
import org.hibernate.search.engine.metadata.impl.DocumentFieldPath;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.test.util.impl.ClasspathResourceAsFile;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class TikaBridgeTest {
    private static final String TEST_DOCUMENT_PDF = "/org/hibernate/search/test/bridge/builtin/test-document-1.pdf";
    @Rule
    public ClasspathResourceAsFile testDocumentPdf = new ClasspathResourceAsFile(this.getClass(), "/org/hibernate/search/test/bridge/builtin/test-document-1.pdf");
    private final String testFieldName = "content";
    private TikaBridge bridgeUnderTest;
    private Document testDocument;
    private LuceneOptions options;

    @Before
    public void setUp() {
        this.bridgeUnderTest = new TikaBridge();
        this.testDocument = new Document();
        DocumentFieldMetadata fieldMetadata = new DocumentFieldMetadata.Builder(new BackReference(), new BackReference(), null, new DocumentFieldPath("", ""), Store.YES, Field.Index.ANALYZED, Field.TermVector.NO).boost(Float.valueOf(0.0f)).build();
        this.options = new LuceneOptionsImpl(fieldMetadata, 1.0f, 1.0f);
        CustomTikaMetadataProcessor.invocationCount = 0;
        CustomTikaParseContextProvider.invocationCount = 0;
    }

    @Test
    public void testPdfToString() throws Exception {
        this.bridgeUnderTest.setAppliedOnType(URI.class);
        URI pdfUri = this.testDocumentPdf.get().toURI();
        this.bridgeUnderTest.set("content", (Object)pdfUri, this.testDocument, this.options);
        Assert.assertEquals((String)"Wrong extracted text", (Object)"Hibernate Search pdf test document", (Object)this.testDocument.get("content").trim());
    }

    @Test
    public void testUnknownTikaMetadataProcessor() throws Exception {
        try {
            this.bridgeUnderTest.setMetadataProcessorClass(this.getClass());
            Assert.fail();
        }
        catch (SearchException e) {
            Assert.assertEquals((String)"Wrong error message", (Object)"Wrong configuration of Tika parse context provider: class org.hibernate.search.test.bridge.builtin.TikaBridgeTest does not implement interface org.hibernate.search.bridge.TikaMetadataProcessor", (Object)e.getMessage());
        }
    }

    @Test
    public void testPrepareMetadata() {
        this.bridgeUnderTest.setMetadataProcessorClass(CustomTikaMetadataProcessor.class);
        this.bridgeUnderTest.setAppliedOnType(String.class);
        this.bridgeUnderTest.set("content", (Object)this.testDocumentPdf.get().getPath(), this.testDocument, this.options);
        Assert.assertEquals((String)"The set method of the custom metadata processor should have been called", (long)1L, (long)CustomTikaMetadataProcessor.invocationCount);
    }

    @Test
    public void testIndexingMetadata() {
        this.bridgeUnderTest.setMetadataProcessorClass(CustomTikaMetadataProcessor.class);
        this.bridgeUnderTest.setAppliedOnType(String.class);
        this.bridgeUnderTest.set("content", (Object)this.testDocumentPdf.get().getPath(), this.testDocument, this.options);
        Assert.assertEquals((String)"The content type should have been indexed", (Object)"application/pdf", (Object)this.testDocument.get("type"));
    }

    @Test
    public void testUnknownTikaParseContextProvider() throws Exception {
        try {
            this.bridgeUnderTest.setParseContextProviderClass(this.getClass());
            Assert.fail();
        }
        catch (SearchException e) {
            Assert.assertEquals((String)"Wrong error message", (Object)"Wrong configuration of Tika metadata processor: class org.hibernate.search.test.bridge.builtin.TikaBridgeTest does not implement interface org.hibernate.search.bridge.TikaParseContextProvider", (Object)e.getMessage());
        }
    }

    @Test
    public void testCustomTikaParseContextProvider() throws Exception {
        this.bridgeUnderTest.setParseContextProviderClass(CustomTikaParseContextProvider.class);
        this.bridgeUnderTest.setAppliedOnType(String.class);
        this.bridgeUnderTest.set("content", (Object)this.testDocumentPdf.get().getPath(), this.testDocument, this.options);
        Assert.assertEquals((String)"The getParseContext method of the custom parse context provider should have been called", (long)1L, (long)CustomTikaParseContextProvider.invocationCount);
    }

    @Test
    public void testInvalidPath() throws Exception {
        try {
            this.bridgeUnderTest.setAppliedOnType(String.class);
            this.bridgeUnderTest.set("content", (Object)"/foo", this.testDocument, this.options);
        }
        catch (SearchException e) {
            Assert.assertTrue((String)"Wrong error type", (boolean)e.getMessage().startsWith("HSEARCH000152"));
        }
    }

    @Test
    public void testCustomTikaParserProvider() throws Exception {
        this.bridgeUnderTest.setParserProviderClass(CustomTikaParserProvider.class);
        this.bridgeUnderTest.setAppliedOnType(String.class);
        Assert.assertEquals((String)"The createParser method of the custom parser provider should have been called", (long)1L, (long)CustomTikaParserProvider.invocationCount);
        this.bridgeUnderTest.set("content", (Object)this.testDocumentPdf.get().getPath(), this.testDocument, this.options);
        Assert.assertEquals((String)("The content should have been set to '" + CustomTikaParserProvider.RESULT + "'"), (Object)CustomTikaParserProvider.RESULT, (Object)this.testDocument.get("content"));
    }

    public static class CustomTikaParseContextProvider
    implements TikaParseContextProvider {
        public static int invocationCount = 0;

        public ParseContext getParseContext(String name, Object value) {
            ++invocationCount;
            return new ParseContext();
        }
    }

    public static class CustomTikaMetadataProcessor
    implements TikaMetadataProcessor {
        public static int invocationCount = 0;

        public Metadata prepareMetadata() {
            Metadata meta = new Metadata();
            meta.add("resourceName", "foo");
            return meta;
        }

        public void set(String name, Object value, Document document, LuceneOptions luceneOptions, Metadata metadata) {
            ++invocationCount;
            Assert.assertEquals((String)"Metadata.RESOURCE_NAME_KEY should be set in the metadata", (Object)"foo", (Object)metadata.get("resourceName"));
            luceneOptions.addFieldToDocument("type", metadata.get("Content-Type"), document);
        }
    }

    public static class CustomTikaParserProvider
    implements TikaParserProvider {
        public static int invocationCount = 0;
        public static String RESULT = "foo";

        public Parser createParser() {
            ++invocationCount;
            return new Parser(){

                public Set<MediaType> getSupportedTypes(ParseContext context) {
                    return Collections.singleton(MediaType.application((String)"pdf"));
                }

                public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws SAXException {
                    handler.startDocument();
                    handler.characters(RESULT.toCharArray(), 0, RESULT.length());
                    handler.endDocument();
                }
            };
        }
    }
}

