/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.bridge.time;

import java.time.LocalDate;
import org.assertj.core.api.Assertions;
import org.hibernate.search.bridge.builtin.time.impl.LocalDateBridge;
import org.junit.Test;

public class LocalDateBridgeTest {
    private static final LocalDateBridge BRIDGE = LocalDateBridge.INSTANCE;

    @Test
    public void testMaxObjectToString() throws Exception {
        Assertions.assertThat((String)BRIDGE.objectToString((Object)LocalDate.MAX)).isEqualTo((Object)"+9999999991231");
    }

    @Test
    public void testMinObjectToString() throws Exception {
        Assertions.assertThat((String)BRIDGE.objectToString((Object)LocalDate.MIN)).isEqualTo((Object)"-9999999990101");
    }

    @Test
    public void testPaddingObjectToString() throws Exception {
        Assertions.assertThat((String)BRIDGE.objectToString((Object)LocalDate.of(1, 2, 3))).isEqualTo((Object)"+0000000010203");
    }

    @Test
    public void testMaxStringToObject() throws Exception {
        Assertions.assertThat((Object)BRIDGE.stringToObject("+9999999991231")).isEqualTo((Object)LocalDate.MAX);
    }

    @Test
    public void testMinStringToObject() throws Exception {
        Assertions.assertThat((Object)BRIDGE.stringToObject("-9999999990101")).isEqualTo((Object)LocalDate.MIN);
    }

    @Test
    public void testPaddingStringToObject() throws Exception {
        Assertions.assertThat((Object)BRIDGE.stringToObject("+0000000010203")).isEqualTo((Object)LocalDate.of(1, 2, 3));
    }
}

