/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.sorting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.assertj.core.api.Assertions;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.engine.metadata.impl.SortableFieldMetadata;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.filter.FullTextFilterImplementor;
import org.hibernate.search.filter.impl.FullTextFilterImpl;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.query.engine.impl.SortConfigurations;
import org.hibernate.search.reader.impl.ManagedMultiReader;
import org.hibernate.search.reader.impl.MultiReaderFactory;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.impl.PojoIndexedTypeIdentifier;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.junit.SkipOnElasticsearch;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SkipOnElasticsearch.class})
public class ManagedMultiReaderTest {
    private static final IndexedTypeIdentifier PERSON_TYPE = new PojoIndexedTypeIdentifier(Person.class);
    private static final IndexedTypeIdentifier CUSTOMER_TYPE = new PojoIndexedTypeIdentifier(Customer.class);
    @Rule
    public SearchFactoryHolder factoryHolder = new SearchFactoryHolder(Person.class, Customer.class);

    @Test
    public void testStandardReaderIsUsedIfAllSortsAreCovered() throws Exception {
        ExtendedSearchIntegrator integrator = this.factoryHolder.getSearchFactory();
        EntityIndexBinding binding = integrator.getIndexBinding(PERSON_TYPE);
        Set indexManagers = binding.getIndexManagerSelector().forFilters((FullTextFilterImplementor[])new FullTextFilterImpl[0]);
        Sort sort = new Sort(new SortField[]{new SortField("ageForIntSorting", SortField.Type.INT), new SortField("ageForStringSorting", SortField.Type.STRING)});
        SortConfigurations configuredSorts = new SortConfigurations.Builder().setIndex("test").setEntityType(PERSON_TYPE).addSortableFields(Arrays.asList(new SortableFieldMetadata.Builder("ageForIntSorting").build(), new SortableFieldMetadata.Builder("ageForStringSorting").build())).build();
        IndexManager[] indexManagersArray = indexManagers.toArray(new IndexManager[indexManagers.size()]);
        try (ManagedMultiReader reader = (ManagedMultiReader)MultiReaderFactory.openReader((SortConfigurations)configuredSorts, (Sort)sort, (IndexManager[])indexManagersArray, (boolean)false);){
            List actualReaders = reader.getSubReaders();
            Assertions.assertThat((List)actualReaders).hasSize(1);
            Assertions.assertThat((String)((IndexReader)actualReaders.get(0)).getClass().getSimpleName()).isEqualTo((Object)"StandardDirectoryReader");
        }
    }

    @Test
    public void testUninvertingReaderIsUsedIfNotAllSortsAreCovered() throws Exception {
        ExtendedSearchIntegrator integrator = this.factoryHolder.getSearchFactory();
        EntityIndexBinding binding = integrator.getIndexBinding(PERSON_TYPE);
        Set indexManagers = binding.getIndexManagerSelector().forFilters((FullTextFilterImplementor[])new FullTextFilterImpl[0]);
        Sort sort = new Sort(new SortField[]{new SortField("ageForIntSorting", SortField.Type.INT), new SortField("ageForStringSorting", SortField.Type.STRING)});
        SortConfigurations configuredSorts = new SortConfigurations.Builder().setIndex("person").setEntityType(PERSON_TYPE).addSortableFields(Arrays.asList(new SortableFieldMetadata.Builder("ageForStringSorting").build())).build();
        IndexManager[] indexManagersArray = indexManagers.toArray(new IndexManager[indexManagers.size()]);
        try (ManagedMultiReader reader = (ManagedMultiReader)MultiReaderFactory.openReader((SortConfigurations)configuredSorts, (Sort)sort, (IndexManager[])indexManagersArray, (boolean)true);){
            List actualReaders = reader.getSubReaders();
            Assertions.assertThat((List)actualReaders).hasSize(1);
            Assertions.assertThat((String)((IndexReader)actualReaders.get(0)).getClass().getSimpleName()).isEqualTo((Object)"UninvertingDirectoryReader");
        }
    }

    @Test
    public void testCombinationOfStandardAndUninvertingReaderAsRequiredToSortOnInvolvedIndexes() throws Exception {
        ExtendedSearchIntegrator integrator = this.factoryHolder.getSearchFactory();
        EntityIndexBinding binding = integrator.getIndexBinding(PERSON_TYPE);
        ArrayList indexManagers = new ArrayList(binding.getIndexManagerSelector().forFilters((FullTextFilterImplementor[])new FullTextFilterImpl[0]));
        binding = integrator.getIndexBinding(CUSTOMER_TYPE);
        indexManagers.addAll(binding.getIndexManagerSelector().forFilters((FullTextFilterImplementor[])new FullTextFilterImpl[0]));
        Sort sort = new Sort(new SortField[]{new SortField("ageForIntSorting", SortField.Type.INT), new SortField("ageForStringSorting", SortField.Type.STRING)});
        SortConfigurations configuredSorts = new SortConfigurations.Builder().setIndex("person").setEntityType(PERSON_TYPE).addSortableFields(Arrays.asList(new SortableFieldMetadata.Builder("ageForStringSorting").build())).setIndex("customer").setEntityType(CUSTOMER_TYPE).addSortableFields(Arrays.asList(new SortableFieldMetadata.Builder("ageForStringSorting").build(), new SortableFieldMetadata.Builder("ageForIntSorting").build())).build();
        try (ManagedMultiReader reader = (ManagedMultiReader)MultiReaderFactory.openReader((SortConfigurations)configuredSorts, (Sort)sort, (IndexManager[])indexManagers.toArray(new IndexManager[indexManagers.size()]), (boolean)true);){
            List actualReaders = reader.getSubReaders();
            Assertions.assertThat((List)actualReaders).hasSize(2);
            Assertions.assertThat((String)((IndexReader)actualReaders.get(0)).getClass().getSimpleName()).isEqualTo((Object)"UninvertingDirectoryReader");
            Assertions.assertThat((String)((IndexReader)actualReaders.get(1)).getClass().getSimpleName()).isEqualTo((Object)"StandardDirectoryReader");
        }
    }

    @Indexed(index="customer")
    private class Customer {
        @DocumentId
        int id;

        private Customer() {
        }
    }

    @Indexed(index="person")
    private class Person {
        @DocumentId
        int id;

        private Person() {
        }
    }
}

