/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.util.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import org.junit.rules.TestRule;
import org.junit.runners.model.Statement;

public class ExpectedLog4jLog
implements TestRule {
    private List<Matcher<?>> expectations = new ArrayList();
    private List<Matcher<?>> absenceExpectations = new ArrayList();

    public static ExpectedLog4jLog create() {
        return new ExpectedLog4jLog();
    }

    private ExpectedLog4jLog() {
    }

    public Statement apply(Statement base, org.junit.runner.Description description) {
        return new ExpectedLogStatement(base);
    }

    public void expectEvent(Matcher<? extends LoggingEvent> matcher) {
        this.expectations.add(matcher);
    }

    public void expectEventMissing(Matcher<? extends LoggingEvent> matcher) {
        this.absenceExpectations.add(matcher);
    }

    public void expectLevelMissing(final Level level) {
        this.expectEventMissing((Matcher<? extends LoggingEvent>)new TypeSafeMatcher<LoggingEvent>(){

            public void describeTo(Description description) {
                description.appendText("a LoggingEvent with ").appendValue((Object)level).appendText(" level or higher");
            }

            protected boolean matchesSafely(LoggingEvent item) {
                return item.getLevel().isGreaterOrEqual((Priority)level);
            }
        });
    }

    public void expectMessage(String containedString) {
        this.expectMessage((Matcher<String>)CoreMatchers.containsString((String)containedString));
    }

    public void expectMessageMissing(String containedString) {
        this.expectMessageMissing((Matcher<String>)CoreMatchers.containsString((String)containedString));
    }

    public void expectMessage(String containedString, String ... otherContainedStrings) {
        this.expectMessage(this.containsAllStrings(containedString, otherContainedStrings));
    }

    public void expectMessageMissing(String containedString, String ... otherContainedStrings) {
        this.expectMessageMissing(this.containsAllStrings(containedString, otherContainedStrings));
    }

    public void expectMessage(Matcher<String> matcher) {
        this.expectEvent(this.eventMessageMatcher(matcher));
    }

    public void expectMessageMissing(Matcher<String> matcher) {
        this.expectEventMissing(this.eventMessageMatcher(matcher));
    }

    private Matcher<String> containsAllStrings(String containedString, String ... otherContainedStrings) {
        ArrayList<Matcher> matchers = new ArrayList<Matcher>();
        matchers.add(CoreMatchers.containsString((String)containedString));
        for (String otherContainedString : otherContainedStrings) {
            matchers.add(CoreMatchers.containsString((String)otherContainedString));
        }
        return CoreMatchers.allOf(matchers);
    }

    private Matcher<LoggingEvent> eventMessageMatcher(final Matcher<String> messageMatcher) {
        return new TypeSafeMatcher<LoggingEvent>(){

            public void describeTo(Description description) {
                description.appendText("a LoggingEvent with message matching ");
                messageMatcher.describeTo(description);
            }

            protected boolean matchesSafely(LoggingEvent item) {
                return messageMatcher.matches(item.getMessage());
            }
        };
    }

    private static String buildFailureMessage(Set<Matcher<?>> missingSet, Set<LoggingEvent> unexpectedEvents) {
        StringDescription description = new StringDescription();
        description.appendText("Produced logs did not meet the expectations.");
        if (!missingSet.isEmpty()) {
            description.appendText("\nMissing logs:");
            for (Matcher<?> missing : missingSet) {
                description.appendText("\n\t");
                missing.describeTo((Description)description);
            }
        }
        if (!unexpectedEvents.isEmpty()) {
            description.appendText("\nUnexpected logs:");
            for (LoggingEvent unexpected : unexpectedEvents) {
                description.appendText("\n\t");
                description.appendText(unexpected.getRenderedMessage());
            }
        }
        return description.toString();
    }

    private class ExpectedLogStatement
    extends Statement {
        private final Statement next;

        public ExpectedLogStatement(Statement base) {
            this.next = base;
        }

        public void evaluate() throws Throwable {
            Logger logger = Logger.getRootLogger();
            TestAppender appender = new TestAppender();
            logger.addAppender((Appender)appender);
            try {
                this.next.evaluate();
            }
            finally {
                logger.removeAppender((Appender)appender);
            }
            Set<Matcher<?>> expectationsNotMet = appender.getExpectationsNotMet();
            Set<LoggingEvent> unexpectedEvents = appender.getUnexpectedEvents();
            if (!expectationsNotMet.isEmpty() || !unexpectedEvents.isEmpty()) {
                Assert.fail((String)ExpectedLog4jLog.buildFailureMessage(expectationsNotMet, unexpectedEvents));
            }
        }
    }

    private class TestAppender
    extends AppenderSkeleton {
        private final Set<Matcher<?>> expectationsMet = new HashSet();
        private final Set<LoggingEvent> unexpectedEvents = new HashSet<LoggingEvent>();

        private TestAppender() {
        }

        public void close() {
        }

        public boolean requiresLayout() {
            return false;
        }

        protected void append(LoggingEvent event) {
            for (Matcher expectation : ExpectedLog4jLog.this.expectations) {
                if (this.expectationsMet.contains(expectation) || !expectation.matches((Object)event)) continue;
                this.expectationsMet.add(expectation);
            }
            for (Matcher absenceExpectation : ExpectedLog4jLog.this.absenceExpectations) {
                if (!absenceExpectation.matches((Object)event)) continue;
                this.unexpectedEvents.add(event);
            }
        }

        public Set<Matcher<?>> getExpectationsNotMet() {
            HashSet expectationsNotMet = new HashSet();
            expectationsNotMet.addAll(ExpectedLog4jLog.this.expectations);
            expectationsNotMet.removeAll(this.expectationsMet);
            return expectationsNotMet;
        }

        public Set<LoggingEvent> getUnexpectedEvents() {
            return this.unexpectedEvents;
        }
    }
}

