/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.analyzer.definition;

import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.Version;
import org.hibernate.search.test.analyzer.definition.Team;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.junit.SearchITHelper;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class AnalyzerBuilderIndexingTest {
    @Rule
    public final SearchFactoryHolder sfHolder = new SearchFactoryHolder(Team.class).withProperty("hibernate.search.lucene_version", Version.LATEST.toString());
    private final SearchITHelper helper = new SearchITHelper(this.sfHolder);
    private final String analyzerName;
    private final String stringToIndex;
    private final String[] expectedTokens;
    private final String[] unexpectedTokens;

    @Parameterized.Parameters(name="Analyzer {0}, terms {1}")
    public static Object[][] data() {
        return new Object[][]{{"customanalyzer", "This is a D\u00e0scription", new String[]{"dascript"}, new String[]{"D\u00e0scription", "dascription", "is"}}, {"stemmer_override_analyzer", "This is a D\u00e0scription", new String[]{"dascription"}, new String[]{"D\u00e0scription", "dascript"}}, {"standard_analyzer", "This is just FOOBAR's", new String[]{"This", "is", "just", "FOOBAR's"}, new String[]{"FOOBAR"}}, {"html_standard_analyzer", "This is <b>foo</b><i>bar's</i>", new String[]{"This", "is", "foobar's"}, new String[]{"<b>", "b"}}, {"html_whitespace_analyzer", "This is <b>foo</b><i>bar's</i>", new String[]{"This", "is", "foobar's"}, new String[]{"<b>", "b"}}, {"trim_analyzer", " Kittens!   ", new String[]{"Kittens!"}, new String[]{" Kittens!   "}}, {"length_analyzer", "ab abc abcd abcde abcdef", new String[]{"abc", "abcd", "abcde"}, new String[]{"ab", "abcdef"}}, {"porter_analyzer", "bikes", new String[]{"bike"}, new String[]{"bikes"}}, {"porter_analyzer", "biking", new String[]{"bike"}, new String[]{"biking"}}, {"word_analyzer", "CamelCase", new String[]{"Camel", "Case"}, new String[]{"CamelCase"}}, {"synonym_analyzer", "ipod cosmos", new String[]{"ipod", "universe"}, new String[]{"cosmos"}}, {"shingle_analyzer", "please divide this sentence into shingles", new String[]{"please", "please divide", "divide", "divide this", "this", "this sentence", "sentence", "sentence into", "into", "into shingles", "shingles"}, new String[]{"please divide this"}}, {"pattern_analyzer", "foo,bar", new String[]{"foo", "bar"}, new String[]{"foo,bar"}}, {"mapping_char_analyzer", "CORA\u00c7\u00c3O DE MEL\u00c3O", new String[]{"CORACAO", "DE", "MELAO"}, new String[]{"CORA\u00c7\u00c3O"}}, {"custom_normalizer", "This is a D\u00e0scription", new String[]{"this is a dascription"}, new String[]{"This", "this", "is", "a", "D\u00e0scription", "dascription"}}};
    }

    public AnalyzerBuilderIndexingTest(String analyzerName, String stringToIndex, String[] expectedTokens, String[] unexpectedTokens) {
        this.analyzerName = analyzerName;
        this.stringToIndex = stringToIndex;
        this.expectedTokens = expectedTokens;
        this.unexpectedTokens = unexpectedTokens;
    }

    @Test
    public void test() {
        TermQuery query;
        String fieldName;
        Team team = new Team(1);
        team.setName(this.stringToIndex);
        this.helper.index(team);
        if (this.unexpectedTokens != null) {
            for (String token : this.unexpectedTokens) {
                fieldName = "name_" + this.analyzerName;
                query = new TermQuery(new Term(fieldName, token));
                this.helper.assertThat((Query)query).as("Results of searching '" + token + "' on field '" + fieldName + "'").matchesNone();
            }
        }
        for (String token : this.expectedTokens) {
            fieldName = "name_" + this.analyzerName;
            query = new TermQuery(new Term(fieldName, token));
            this.helper.assertThat((Query)query).as("Results of searching '" + token + "' on field '" + fieldName + "'").matchesExactlyIds(team.getId());
        }
    }
}

