/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.bridge;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.search.Query;
import org.hibernate.search.annotations.ContainedIn;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.junit.SearchITHelper;
import org.junit.Rule;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-3407")
public class MultiValuedBooleanBridgeTest {
    @Rule
    public final SearchFactoryHolder sfHolder = new SearchFactoryHolder(ParentEntity.class, ChildEntity.class);
    private final SearchITHelper helper = new SearchITHelper(this.sfHolder);

    @Test
    public void test() {
        ChildEntity childEntity1 = new ChildEntity(1L, true);
        ChildEntity childEntity2 = new ChildEntity(2L, false);
        ParentEntity yourEntity1 = new ParentEntity(1L, childEntity1, childEntity2);
        this.helper.add(yourEntity1);
        QueryBuilder qb = this.helper.queryBuilder(ParentEntity.class);
        Query query = qb.keyword().onField("children.booleanProperty").matching((Object)true).createQuery();
        this.helper.assertThat(query).matchesExactlyIds(Long.valueOf(1L));
        query = qb.keyword().onField("children.booleanProperty").matching((Object)false).createQuery();
        this.helper.assertThat(query).matchesExactlyIds(Long.valueOf(1L));
    }

    @Indexed
    public static class ChildEntity {
        @DocumentId
        private Long id;
        @ContainedIn
        private ParentEntity parent;
        @Field
        private boolean booleanProperty;

        protected ChildEntity() {
        }

        public ChildEntity(Long id, boolean booleanProperty) {
            this.id = id;
            this.booleanProperty = booleanProperty;
        }

        public Long getId() {
            return this.id;
        }

        public boolean getBooleanProperty() {
            return this.booleanProperty;
        }

        public void setBooleanProperty(boolean booleanProperty) {
            this.booleanProperty = booleanProperty;
        }

        protected void setParent(ParentEntity parent) {
            this.parent = parent;
        }
    }

    @Indexed
    public static class ParentEntity {
        @DocumentId
        private Long id;
        @IndexedEmbedded
        private List<ChildEntity> children = new ArrayList<ChildEntity>();

        protected ParentEntity() {
        }

        public ParentEntity(Long id, ChildEntity ... childEntities) {
            this.id = id;
            Arrays.stream(childEntities).forEach(this::addChildEntity);
        }

        public Long getId() {
            return this.id;
        }

        public List<ChildEntity> getChildren() {
            return Collections.unmodifiableList(this.children);
        }

        public void addChildEntity(ChildEntity child) {
            child.setParent(this);
            this.children.add(child);
        }
    }
}

