/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.dsl;

import java.util.Date;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Analyzer;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.DateBridge;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.FieldBridge;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Normalizer;
import org.hibernate.search.annotations.Norms;
import org.hibernate.search.annotations.Resolution;
import org.hibernate.search.test.dsl.MonthBase0FieldBridge;
import org.hibernate.search.test.dsl.MonthClassBridge;
import org.hibernate.search.test.dsl.RomanNumberFieldBridge;

@Indexed
@ClassBridge(impl=MonthClassBridge.class)
class Month {
    private Integer id;
    private int monthValue;
    @Field
    public double raindropInMm;
    private String name;
    private String mythology;
    private String history;
    private Date estimatedCreation;
    private String keyForOrdering;
    private String htmlDescription;

    public Month(String name, int monthValue, String mythology, String history, Date estimatedCreation) {
        this.id = monthValue;
        this.name = name;
        this.mythology = mythology;
        this.history = history;
        this.estimatedCreation = estimatedCreation;
        this.monthValue = monthValue;
    }

    public Month(String name, int monthValue, String mythology, String history, Date estimatedCreation, double raindropInMm, String keyForOrdering, String htmlDescription) {
        this(name, monthValue, mythology, history, estimatedCreation);
        this.raindropInMm = raindropInMm;
        this.keyForOrdering = keyForOrdering;
        this.htmlDescription = htmlDescription;
    }

    @DocumentId
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @Fields(value={@Field(analyze=Analyze.NO, norms=Norms.NO), @Field(analyze=Analyze.NO, norms=Norms.NO, name="monthRomanNumber", bridge=@FieldBridge(impl=RomanNumberFieldBridge.class)), @Field(analyze=Analyze.NO, norms=Norms.NO, name="monthBase0", bridge=@FieldBridge(impl=MonthBase0FieldBridge.class))})
    public int getMonthValue() {
        return this.monthValue;
    }

    public void setMonthValue(int monthValue) {
        this.monthValue = monthValue;
    }

    @Field(normalizer=@Normalizer(definition="lower"))
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Fields(value={@Field, @Field(name="mythology_stem", analyzer=@Analyzer(definition="stemmer")), @Field(name="mythology_ngram", analyzer=@Analyzer(definition="ngram")), @Field(name="mythology_same_base_as_ngram", analyzer=@Analyzer(definition="same_base_as_ngram")), @Field(name="mythology_normalized", normalizer=@Normalizer(definition="lower"))})
    public String getMythology() {
        return this.mythology;
    }

    public void setMythology(String mythology) {
        this.mythology = mythology;
    }

    @Field
    public String getHistory() {
        return this.history;
    }

    public void setHistory(String history) {
        this.history = history;
    }

    @Field(analyze=Analyze.NO)
    @DateBridge(resolution=Resolution.MINUTE)
    public Date getEstimatedCreation() {
        return this.estimatedCreation;
    }

    public void setEstimatedCreation(Date estimatedCreation) {
        this.estimatedCreation = estimatedCreation;
    }

    @Field(analyze=Analyze.NO, indexNullAs="_null_")
    public String getKeyForOrdering() {
        return this.keyForOrdering;
    }

    public void setKeyForOrdering(String keyForOrdering) {
        this.keyForOrdering = keyForOrdering;
    }

    @Fields(value={@Field, @Field(name="htmlDescription_htmlStrip", analyzer=@Analyzer(definition="htmlStrip"))})
    public String getHtmlDescription() {
        return this.htmlDescription;
    }

    public void setHtmlDescription(String htmlDescription) {
        this.htmlDescription = htmlDescription;
    }
}

