/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.bridge.time;

import java.time.YearMonth;
import org.assertj.core.api.Assertions;
import org.hibernate.search.bridge.builtin.time.impl.YearMonthBridge;
import org.junit.Test;

public class YearMonthBridgeTest {
    private static final YearMonthBridge BRIDGE = YearMonthBridge.INSTANCE;
    private static final YearMonth MAX_VALUE = YearMonth.of(999999999, 12);
    private static final YearMonth MIN_VALUE = YearMonth.of(-999999999, 12);
    private static final YearMonth CUSTOM_VALUE = YearMonth.of(-12434, 1);
    private static final String MAX = "+99999999912";
    private static final String MIN = "-99999999912";
    private static final String CST = "-00001243401";

    @Test
    public void testMaxObjectToString() throws Exception {
        Assertions.assertThat((String)BRIDGE.objectToString((Object)MAX_VALUE)).isEqualTo((Object)MAX);
    }

    @Test
    public void testMinObjectToString() throws Exception {
        Assertions.assertThat((String)BRIDGE.objectToString((Object)MIN_VALUE)).isEqualTo((Object)MIN);
    }

    @Test
    public void testPaddingObjectToString() throws Exception {
        Assertions.assertThat((String)BRIDGE.objectToString((Object)CUSTOM_VALUE)).isEqualTo((Object)CST);
    }

    @Test
    public void testMaxStringToObject() throws Exception {
        Assertions.assertThat((Object)BRIDGE.stringToObject(MAX)).isEqualTo((Object)MAX_VALUE);
    }

    @Test
    public void testMinStringToObject() throws Exception {
        Assertions.assertThat((Object)BRIDGE.stringToObject(MIN)).isEqualTo((Object)MIN_VALUE);
    }

    @Test
    public void testPaddingStringToObject() throws Exception {
        Assertions.assertThat((Object)BRIDGE.stringToObject(CST)).isEqualTo((Object)CUSTOM_VALUE);
    }
}

