/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration;

import java.lang.annotation.ElementType;
import java.util.Properties;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.backend.impl.PerTransactionWorker;
import org.hibernate.search.backend.impl.QueueingProcessor;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.backend.spi.Worker;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.testsupport.junit.SearchIntegratorResource;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class WorkerScopeConfigurationTest {
    @Rule
    public SearchIntegratorResource integratorResource = new SearchIntegratorResource();
    private SearchConfigurationForTest manualConfiguration;

    @Before
    public void setUp() {
        this.manualConfiguration = new SearchConfigurationForTest();
        SearchMapping searchMapping = new SearchMapping();
        searchMapping.entity(Document.class).indexed().property("id", ElementType.FIELD).documentId().property("title", ElementType.FIELD).field();
        this.manualConfiguration.setProgrammaticMapping(searchMapping);
        this.manualConfiguration.addClass(Document.class);
    }

    @Test
    public void testDefaultWorker() {
        ExtendedSearchIntegrator searchIntegrator = this.integratorResource.create(this.manualConfiguration);
        Assert.assertNotNull((String)"Worker should have been created", (Object)searchIntegrator.getWorker());
        Assert.assertTrue((String)"Wrong worker class", (boolean)(searchIntegrator.getWorker() instanceof PerTransactionWorker));
    }

    @Test
    public void testExplicitTransactionalWorker() {
        this.manualConfiguration.addProperty("hibernate.search.worker.scope", "transaction");
        ExtendedSearchIntegrator searchIntegrator = this.integratorResource.create(this.manualConfiguration);
        Assert.assertNotNull((String)"Worker should have been created", (Object)searchIntegrator.getWorker());
        Assert.assertTrue((String)"Wrong worker class", (boolean)(searchIntegrator.getWorker() instanceof PerTransactionWorker));
    }

    @Test
    public void testCustomWorker() {
        this.manualConfiguration.addProperty("hibernate.search.worker.scope", CustomWorker.class.getName());
        ExtendedSearchIntegrator searchIntegrator = this.integratorResource.create(this.manualConfiguration);
        Assert.assertNotNull((String)"Worker should have been created", (Object)searchIntegrator.getWorker());
        Assert.assertTrue((String)"Wrong worker class", (boolean)(searchIntegrator.getWorker() instanceof CustomWorker));
    }

    @Test
    public void testCustomWorkerWithProperties() {
        this.manualConfiguration.addProperty("hibernate.search.worker.scope", CustomWorkerExpectingFooAndBar.class.getName());
        this.manualConfiguration.addProperty("hibernate.search.worker.foo", "foo");
        this.manualConfiguration.addProperty("hibernate.search.worker.bar", "bar");
        ExtendedSearchIntegrator searchIntegrator = this.integratorResource.create(this.manualConfiguration);
        Assert.assertNotNull((String)"Worker should have been created", (Object)searchIntegrator.getWorker());
        Assert.assertTrue((String)"Wrong worker class", (boolean)(searchIntegrator.getWorker() instanceof CustomWorkerExpectingFooAndBar));
    }

    @Test
    public void testUnknownWorkerImplementationClass() {
        this.manualConfiguration.addProperty("hibernate.search.worker.scope", "foo");
        try {
            this.integratorResource.create(this.manualConfiguration);
            Assert.fail();
        }
        catch (SearchException e) {
            Assert.assertTrue((String)"Unexpected error message", (boolean)e.getMessage().contains("Unable to find worker implementation class: foo"));
        }
    }

    public static final class CustomWorkerExpectingFooAndBar
    implements Worker {
        public static final String FOO = "hibernate.search.worker.foo";
        public static final String BAR = "hibernate.search.worker.bar";

        public void performWork(Work work, TransactionContext transactionContext) {
        }

        public void initialize(Properties props, WorkerBuildContext context, QueueingProcessor queueingProcessor) {
            Assert.assertTrue((String)"Missing property: hibernate.search.worker.foo", (boolean)props.containsKey(FOO));
            Assert.assertTrue((String)"Missing property: hibernate.search.worker.bar", (boolean)props.containsKey(BAR));
        }

        public void close() {
        }

        public void flushWorks(TransactionContext transactionContext) {
        }
    }

    public static final class CustomWorker
    implements Worker {
        public void performWork(Work work, TransactionContext transactionContext) {
        }

        public void initialize(Properties props, WorkerBuildContext context, QueueingProcessor queueingProcessor) {
        }

        public void close() {
        }

        public void flushWorks(TransactionContext transactionContext) {
        }
    }

    public static final class Document {
        private long id;
        private String title;
    }
}

