/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.id;

import org.apache.lucene.document.Document;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.FieldBridge;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.junit.SearchITHelper;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

@TestForIssue(jiraKey="HSEARCH-2636")
public class MissingIdTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Rule
    public final SearchFactoryHolder sfHolder = new SearchFactoryHolder(EntityWithMissingIdWhenRetrievedFromIndex.class);
    private final SearchITHelper helper = new SearchITHelper(this.sfHolder);

    @Test
    public void multipleResults_singleClass() throws Exception {
        EntityWithMissingIdWhenRetrievedFromIndex entity1 = new EntityWithMissingIdWhenRetrievedFromIndex();
        entity1.id = "1";
        EntityWithMissingIdWhenRetrievedFromIndex entity2 = new EntityWithMissingIdWhenRetrievedFromIndex();
        entity2.id = "2";
        this.helper.add(entity1, entity2);
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage("HSEARCH000338");
        this.thrown.expectMessage("Incomplete entity information");
        this.thrown.expectMessage("'" + EntityWithMissingIdWhenRetrievedFromIndex.class.getName() + "'");
        ((EntityInfo)this.sfHolder.getSearchFactory().createHSQuery((Query)new MatchAllDocsQuery(), new Class[]{EntityWithMissingIdWhenRetrievedFromIndex.class}).queryEntityInfos().iterator().next()).getId();
    }

    public static class MissingIdMockingFieldBridge
    implements TwoWayFieldBridge {
        public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
            luceneOptions.addFieldToDocument(name, (String)value, document);
        }

        public Object get(String name, Document document) {
            return null;
        }

        public String objectToString(Object object) {
            return (String)object;
        }
    }

    @Indexed
    private static class EntityWithMissingIdWhenRetrievedFromIndex {
        @DocumentId
        @FieldBridge(impl=MissingIdMockingFieldBridge.class)
        private String id;

        private EntityWithMissingIdWhenRetrievedFromIndex() {
        }
    }
}

