/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.backend.lucene;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.backend.impl.CommitPolicy;
import org.hibernate.search.backend.impl.lucene.AbstractWorkspaceImpl;
import org.hibernate.search.backend.impl.lucene.ScheduledCommitPolicy;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.backend.spi.WorkType;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.hibernate.search.test.backend.lucene.Condition;
import org.hibernate.search.test.backend.lucene.Conditions;
import org.hibernate.search.test.backend.lucene.Quote;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.setup.CountingErrorHandler;
import org.hibernate.search.testsupport.setup.TransactionContextForTest;
import org.jboss.byteman.contrib.bmunit.BMRule;
import org.jboss.byteman.contrib.bmunit.BMUnitRunner;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=BMUnitRunner.class)
public class ScheduledCommitPolicyTest {
    private static final int NUMBER_ENTITIES = 1000;
    private int globalIdCounter = 0;
    @Rule
    public SearchFactoryHolder sfAsyncExclusiveIndex = new SearchFactoryHolder(Quote.class).withProperty("hibernate.search.default.index_flush_interval", "100").withProperty("hibernate.search.default.worker.execution", "async").withProperty("hibernate.search.default.exclusive_index_use", "true").withProperty("hibernate.search.error_handler", CountingErrorHandler.class.getName());

    @Test
    public void testScheduledCommits() throws Exception {
        this.writeData(this.sfAsyncExclusiveIndex, 1000);
        AbstractWorkspaceImpl workspace = this.sfAsyncExclusiveIndex.extractWorkspace(Quote.class);
        CommitPolicy commitPolicy = workspace.getCommitPolicy();
        Assert.assertTrue((boolean)(commitPolicy instanceof ScheduledCommitPolicy));
        ScheduledCommitPolicy scheduledCommitPolicy = (ScheduledCommitPolicy)commitPolicy;
        ScheduledThreadPoolExecutor scheduledExecutor = (ScheduledThreadPoolExecutor)scheduledCommitPolicy.getScheduledExecutorService();
        Conditions.assertConditionMet(new TaskExecutedCondition(scheduledExecutor, 1));
    }

    @Test
    @BMRule(targetClass="org.apache.lucene.index.IndexWriter", targetMethod="commit", action="throw new IOException(\"File not found!\")", name="commitError")
    public void testErrorHandling() throws Exception {
        this.writeData(this.sfAsyncExclusiveIndex, 2);
        final CountingErrorHandler errorHandler = (CountingErrorHandler)this.sfAsyncExclusiveIndex.getSearchFactory().getErrorHandler();
        Conditions.assertConditionMet(new Condition(){

            @Override
            public boolean evaluate() {
                return errorHandler.getCountFor(IOException.class) >= 2;
            }
        });
    }

    @Test
    public void testDocVisibility() throws Exception {
        this.writeData(this.sfAsyncExclusiveIndex, 1000);
        Conditions.assertConditionMet(new IndexingFinishedCondition(this.sfAsyncExclusiveIndex, 1000));
        this.writeData(this.sfAsyncExclusiveIndex, 10);
        Conditions.assertConditionMet(new IndexingFinishedCondition(this.sfAsyncExclusiveIndex, 1010));
        this.writeData(this.sfAsyncExclusiveIndex, 1);
        Conditions.assertConditionMet(new IndexingFinishedCondition(this.sfAsyncExclusiveIndex, 1011));
    }

    private void writeData(SearchFactoryHolder sfHolder, int numberEntities) {
        for (int i = 0; i < numberEntities; ++i) {
            Integer id = this.globalIdCounter++;
            Quote quote = new Quote(id, "description");
            Work work = new Work((Object)quote, (Serializable)id, WorkType.ADD, false);
            TransactionContextForTest tc = new TransactionContextForTest();
            sfHolder.getSearchFactory().getWorker().performWork(work, (TransactionContext)tc);
            tc.end();
        }
    }

    private class TaskExecutedCondition
    implements Condition {
        private final ScheduledThreadPoolExecutor executor;
        private final int taskCount;

        private TaskExecutedCondition(ScheduledThreadPoolExecutor executor, int taskCount) {
            this.executor = executor;
            this.taskCount = taskCount;
        }

        @Override
        public boolean evaluate() {
            return this.executor.getCompletedTaskCount() >= (long)this.taskCount;
        }
    }

    private class IndexingFinishedCondition
    implements Condition {
        private final int expectedDocsCount;
        private final ExtendedSearchIntegrator searchFactory;

        private IndexingFinishedCondition(SearchFactoryHolder searchFactoryHolder, int expectedDocsCount) {
            this.searchFactory = searchFactoryHolder.getSearchFactory();
            this.expectedDocsCount = expectedDocsCount;
        }

        private HSQuery matchAllQuery() {
            return this.searchFactory.createHSQuery().luceneQuery((Query)new MatchAllDocsQuery()).targetedEntities(Arrays.asList(Quote.class));
        }

        @Override
        public boolean evaluate() {
            return this.expectedDocsCount == this.matchAllQuery().queryResultSize();
        }
    }
}

