/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration;

import java.io.IOException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.lucene.index.IndexWriter;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.backend.impl.lucene.AbstractWorkspaceImpl;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.util.logging.impl.LogCategory;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-1508")
public class IndexWriterTuningAppliedTest {
    @Rule
    public SearchFactoryHolder sfHolder = new SearchFactoryHolder(Dvd.class, Book.class).withProperty("hibernate.search.default.indexwriter.max_thread_states", "23").withProperty("hibernate.search.index2.indexwriter.max_thread_states", "7").withProperty("hibernate.search.index2.indexwriter.infostream", "true");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIndexWriterTuningApplied() throws IOException {
        AbstractWorkspaceImpl dvdsWorkspace = this.sfHolder.extractWorkspace(Dvd.class);
        try (IndexWriter dvdsIndexWriter = dvdsWorkspace.getIndexWriter();){
            Assert.assertEquals((long)23L, (long)dvdsIndexWriter.getConfig().getMaxThreadStates());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInfoStream() throws IOException {
        Logger.getLogger((String)LogCategory.INFOSTREAM_LOGGER_CATEGORY.getName()).setLevel(Level.TRACE);
        AbstractWorkspaceImpl dvdsWorkspace = this.sfHolder.extractWorkspace(Dvd.class);
        AbstractWorkspaceImpl booksWorkspace = this.sfHolder.extractWorkspace(Book.class);
        IndexWriter dvdsIndexWriter = dvdsWorkspace.getIndexWriter();
        IndexWriter booksIndexWriter = booksWorkspace.getIndexWriter();
        try {
            Assert.assertFalse((boolean)dvdsIndexWriter.getConfig().getInfoStream().isEnabled("IW"));
            Assert.assertTrue((boolean)booksIndexWriter.getConfig().getInfoStream().isEnabled("IW"));
        }
        finally {
            booksIndexWriter.close();
            dvdsIndexWriter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIndexWriterTuningAppliedOnDefault() throws IOException {
        AbstractWorkspaceImpl booksWorkspace = this.sfHolder.extractWorkspace(Book.class);
        try (IndexWriter booksIndexWriter = booksWorkspace.getIndexWriter();){
            Assert.assertEquals((long)7L, (long)booksIndexWriter.getConfig().getMaxThreadStates());
        }
    }

    @Indexed(index="index2")
    public static final class Book {
        @DocumentId
        long id;
        @Field
        String title;
    }

    @Indexed(index="index1")
    public static final class Dvd {
        @DocumentId
        long id;
        @Field
        String title;
    }
}

