/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.fileleaks;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.backend.spi.WorkType;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.indexes.spi.DirectoryBasedIndexManager;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.spi.SearchIntegratorBuilder;
import org.hibernate.search.testsupport.leakdetection.FileMonitoringDirectory;
import org.hibernate.search.testsupport.leakdetection.FileMonitoringDirectoryProvider;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.hibernate.search.testsupport.setup.TransactionContextForTest;
import org.junit.Assert;
import org.junit.Test;

public class AllFilesClosedTest {
    private SearchIntegrator searchIntegrator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileHandlesReleased() {
        this.searchIntegrator = this.initializeSearchFactory();
        FileMonitoringDirectory directoryOne = this.getDirectory("index1");
        FileMonitoringDirectory directoryTwo = this.getDirectory("index2");
        try {
            this.doSomeOperations();
            this.assertDirectoryOpen(directoryOne);
            this.assertDirectoryOpen(directoryTwo);
            if (this.nrtNotEnabled()) {
                this.assertAllFilesClosed(directoryTwo);
            }
        }
        finally {
            this.searchIntegrator.close();
        }
        this.assertAllFilesClosed(directoryOne);
        this.assertAllFilesClosed(directoryTwo);
        this.assertDirectoryClosed(directoryOne);
        this.assertDirectoryClosed(directoryTwo);
    }

    protected boolean nrtNotEnabled() {
        return true;
    }

    private void assertAllFilesClosed(FileMonitoringDirectory directory) {
        Assert.assertTrue((String)"not all files were closed", (boolean)directory.allFilesWereClosed());
    }

    private void assertDirectoryClosed(FileMonitoringDirectory directory) {
        Assert.assertTrue((boolean)directory.isClosed());
    }

    private void assertDirectoryOpen(FileMonitoringDirectory directory) {
        Assert.assertFalse((boolean)directory.isClosed());
    }

    private FileMonitoringDirectory getDirectory(String indexName) {
        ExtendedSearchIntegrator implementor = (ExtendedSearchIntegrator)this.searchIntegrator.unwrap(ExtendedSearchIntegrator.class);
        DirectoryBasedIndexManager indexManager = (DirectoryBasedIndexManager)implementor.getIndexManagerHolder().getIndexManager(indexName);
        FileMonitoringDirectoryProvider directoryProvider = (FileMonitoringDirectoryProvider)indexManager.getDirectoryProvider();
        FileMonitoringDirectory directory = (FileMonitoringDirectory)directoryProvider.getDirectory();
        return directory;
    }

    private void doSomeOperations() {
        this.assertElementsInIndex(0);
        this.storeDvd(1, "Aliens");
        this.storeDvd(2, "Predators");
        this.storeBook(1, "Hibernate Search, second edition");
        this.assertElementsInIndex(3);
        this.storeDvd(2, "Prometheus");
        this.storeBook(2, "Prometheus and the Eagle");
        this.assertElementsInIndex(4);
    }

    private void assertElementsInIndex(int expected) {
        HSQuery hsQuery = this.searchIntegrator.createHSQuery();
        hsQuery.luceneQuery((Query)new MatchAllDocsQuery()).targetedEntities(Arrays.asList(Book.class, Dvd.class));
        int resultSize = hsQuery.queryResultSize();
        Assert.assertEquals((long)expected, (long)resultSize);
    }

    private void storeBook(int id, String string) {
        Book book = new Book();
        book.id = id;
        book.title = string;
        this.storeObject(book, Integer.valueOf(id));
    }

    private void storeDvd(int id, String dvdTitle) {
        Dvd dvd1 = new Dvd();
        dvd1.id = id;
        dvd1.title = dvdTitle;
        this.storeObject(dvd1, Integer.valueOf(id));
    }

    private void storeObject(Object entity, Serializable id) {
        Work work = new Work(entity, id, WorkType.UPDATE, false);
        TransactionContextForTest tc = new TransactionContextForTest();
        this.searchIntegrator.getWorker().performWork(work, (TransactionContext)tc);
        tc.end();
    }

    protected SearchIntegrator initializeSearchFactory() {
        SearchConfigurationForTest cfg = new SearchConfigurationForTest().addProperty("hibernate.search.default.directory_provider", FileMonitoringDirectoryProvider.class.getName()).addProperty("hibernate.search.default.reader.strategy", "shared").addProperty("hibernate.search.index2.reader.strategy", "not-shared").addProperty("hibernate.search.index2.exclusive_index_use", "false").addClass(Book.class).addClass(Dvd.class);
        this.overrideProperties(cfg);
        return new SearchIntegratorBuilder().configuration((SearchConfiguration)cfg).buildSearchIntegrator();
    }

    protected void overrideProperties(SearchConfigurationForTest cfg) {
    }

    @Indexed(index="index2")
    public static final class Book {
        @DocumentId
        long id;
        @Field
        String title;
    }

    @Indexed(index="index1")
    public static final class Dvd {
        @DocumentId
        long id;
        @Field
        String title;
    }
}

