/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.sorting;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.FieldBridge;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.ProvidedId;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.backend.spi.WorkType;
import org.hibernate.search.backend.spi.Worker;
import org.hibernate.search.bridge.builtin.IntegerBridge;
import org.hibernate.search.bridge.builtin.LongBridge;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.setup.TransactionContextForTest;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class SortingTest {
    @Rule
    public SearchFactoryHolder factoryHolder = new SearchFactoryHolder(Person.class);
    Person[] testData = new Person[]{new Person(3, "Three"), new Person(10, "Ten"), new Person(9, "Nine"), new Person(5, "Five")};

    @Test
    public void testSortingOnNumericInt() {
        Worker worker = this.factoryHolder.getSearchFactory().getWorker();
        TransactionContextForTest tc = new TransactionContextForTest();
        for (int i = 0; i < this.testData.length; ++i) {
            worker.performWork(new Work((Object)this.testData[i], (Serializable)Long.valueOf(i), WorkType.INDEX), (TransactionContext)tc);
        }
        tc.end();
        Query query = this.factoryHolder.getSearchFactory().buildQueryBuilder().forEntity(Person.class).get().all().createQuery();
        this.assertSortedResults(query, null, 0L, 1L, 2L, 3L);
        Sort sortAsString = new Sort(new SortField("ageForStringSorting", SortField.Type.STRING));
        this.assertSortedResults(query, sortAsString, 1L, 0L, 3L, 2L);
        Sort sortAsInt = new Sort(new SortField("ageForIntSorting", SortField.Type.INT));
        this.assertSortedResults(query, sortAsInt, 0L, 3L, 2L, 1L);
    }

    private void assertSortedResults(Query query, Sort sort, Long ... expectedIds) {
        ExtendedSearchIntegrator integrator = this.factoryHolder.getSearchFactory();
        HSQuery hsQuery = integrator.createHSQuery().luceneQuery(query);
        hsQuery.targetedEntities(Arrays.asList(Person.class));
        if (sort != null) {
            hsQuery.sort(sort);
        }
        Assert.assertEquals((long)expectedIds.length, (long)hsQuery.queryResultSize());
        List queryEntityInfos = hsQuery.queryEntityInfos();
        Assert.assertEquals((long)expectedIds.length, (long)queryEntityInfos.size());
        for (int i = 0; i < expectedIds.length; ++i) {
            EntityInfo entityInfo = (EntityInfo)queryEntityInfos.get(i);
            Assert.assertNotNull((Object)entityInfo);
            Assert.assertEquals((Object)expectedIds[i], (Object)entityInfo.getId());
        }
    }

    @ProvidedId(bridge=@FieldBridge(impl=LongBridge.class))
    @Indexed
    private class Person {
        @Fields(value={@Field(store=Store.YES, analyze=Analyze.NO, bridge=@FieldBridge(impl=IntegerBridge.class), name="ageForStringSorting"), @Field(store=Store.YES, analyze=Analyze.NO, name="ageForIntSorting")})
        final int age;
        @Field
        final String name;

        Person(int age, String name) {
            this.age = age;
            this.name = name;
        }
    }
}

