/*
 * Hibernate Search, full-text search for your domain model
 *
 * License: GNU Lesser General Public License (LGPL), version 2.1 or later
 * See the lgpl.txt file in the root directory or <http://www.gnu.org/licenses/lgpl-2.1.html>.
 */

package org.hibernate.search.query.dsl;

/**
 * Represents the context in which a must clause is described.
 *
 * @author Emmanuel Bernard
 */
public interface MustJunction extends BooleanJunction<MustJunction> {
	/**
	 * Negate the must clause.
	 * Results of the boolean query do NOT match the subquery.
	 *
	 * @return a {@link BooleanJunction}
	 */
	BooleanJunction not();
}
