/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.backend.serialization;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.document.Document;
import org.easymock.EasyMock;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.backend.AddLuceneWork;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.indexes.serialization.spi.Deserializer;
import org.hibernate.search.indexes.serialization.spi.SerializationProvider;
import org.hibernate.search.indexes.serialization.spi.Serializer;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-1637")
public class SerializationInstanceNotReusedTest {
    private CountingSerializationProvider countingServiceInstance = new CountingSerializationProvider();
    @Rule
    public SearchFactoryHolder factoryHolder = new SearchFactoryHolder(Book.class).withService(SerializationProvider.class, this.countingServiceInstance);

    @Test
    public void testPropertiesIndexing() {
        ExtendedSearchIntegrator searchFactory = this.factoryHolder.getSearchFactory();
        IndexManager indexManager = searchFactory.getIndexManagerHolder().getIndexManager("books");
        Assert.assertNotNull((Object)indexManager);
        Assert.assertEquals((long)0L, (long)this.countingServiceInstance.serializerGetCount.get());
        Assert.assertEquals((long)0L, (long)this.countingServiceInstance.deserializerGetCount.get());
        indexManager.getSerializer().toSerializedModel(this.makeSomeWork());
        Assert.assertEquals((long)1L, (long)this.countingServiceInstance.serializerGetCount.get());
        Assert.assertEquals((long)0L, (long)this.countingServiceInstance.deserializerGetCount.get());
        indexManager.getSerializer().toSerializedModel(this.makeSomeWork());
        Assert.assertEquals((long)2L, (long)this.countingServiceInstance.serializerGetCount.get());
        Assert.assertEquals((long)0L, (long)this.countingServiceInstance.deserializerGetCount.get());
        indexManager.getSerializer().toLuceneWorks(this.makeSomeSerializedWork());
        Assert.assertEquals((long)2L, (long)this.countingServiceInstance.serializerGetCount.get());
        Assert.assertEquals((long)1L, (long)this.countingServiceInstance.deserializerGetCount.get());
        indexManager.getSerializer().toLuceneWorks(this.makeSomeSerializedWork());
        Assert.assertEquals((long)2L, (long)this.countingServiceInstance.serializerGetCount.get());
        Assert.assertEquals((long)2L, (long)this.countingServiceInstance.deserializerGetCount.get());
    }

    private byte[] makeSomeSerializedWork() {
        return new byte[]{0, 1, 2};
    }

    private List<LuceneWork> makeSomeWork() {
        LinkedList<LuceneWork> list = new LinkedList<LuceneWork>();
        list.add((LuceneWork)new AddLuceneWork((Serializable)Integer.valueOf(5), "id:5", Book.class, new Document()));
        list.add((LuceneWork)new AddLuceneWork((Serializable)Integer.valueOf(6), "id:6", Book.class, new Document()));
        return list;
    }

    private static class CountingSerializationProvider
    implements SerializationProvider {
        private final AtomicInteger serializerGetCount = new AtomicInteger();
        private final AtomicInteger deserializerGetCount = new AtomicInteger();
        private final Serializer mockSerializer = (Serializer)EasyMock.createNiceMock(Serializer.class);
        private final Deserializer mockDeserializer = (Deserializer)EasyMock.createNiceMock(Deserializer.class);

        CountingSerializationProvider() {
            EasyMock.replay((Object[])new Object[]{this.mockSerializer, this.mockDeserializer});
        }

        public Serializer getSerializer() {
            this.serializerGetCount.incrementAndGet();
            return this.mockSerializer;
        }

        public Deserializer getDeserializer() {
            this.deserializerGetCount.incrementAndGet();
            return this.mockDeserializer;
        }
    }

    @Indexed(index="books")
    private static class Book {
        @DocumentId
        long id;
        @Field
        String title;

        private Book() {
        }
    }
}

