/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.sorting;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.FieldBridge;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.SortableField;
import org.hibernate.search.annotations.SortableFields;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.backend.spi.WorkType;
import org.hibernate.search.backend.spi.Worker;
import org.hibernate.search.bridge.builtin.IntegerBridge;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.setup.TransactionContextForTest;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class SortingTest {
    @Rule
    public SearchFactoryHolder factoryHolder = new SearchFactoryHolder(Person.class);

    @Test
    public void testSortingOnNumericInt() {
        this.storeTestingData(new Person(0, (Integer)3, "Three", new Integer[0]), new Person(1, (Integer)10, "Ten", new Integer[0]), new Person(2, (Integer)9, "Nine", new Integer[0]), new Person(3, (Integer)5, "Five", new Integer[0]));
        Query query = this.factoryHolder.getSearchFactory().buildQueryBuilder().forEntity(Person.class).get().all().createQuery();
        this.assertSortedResults(query, null, 0, 1, 2, 3);
        Sort sortAsString = new Sort(new SortField("ageForStringSorting", SortField.Type.STRING));
        this.assertSortedResults(query, sortAsString, 1, 0, 3, 2);
        Sort sortAsInt = new Sort(new SortField("ageForIntSorting", SortField.Type.INT));
        this.assertSortedResults(query, sortAsInt, 0, 3, 2, 1);
    }

    @Test
    public void testSortingOnString() {
        this.storeTestingData(new Person(0, (Integer)3, "Three", new Integer[0]), new Person(1, (Integer)10, "Ten", new Integer[0]), new Person(2, (Integer)9, "Nine", new Integer[0]), new Person(3, (Integer)5, "Five", new Integer[0]));
        Query query = this.factoryHolder.getSearchFactory().buildQueryBuilder().forEntity(Person.class).get().all().createQuery();
        Sort sortAsString = new Sort(new SortField("name", SortField.Type.STRING));
        this.assertSortedResults(query, sortAsString, 3, 2, 1, 0);
    }

    @Test
    public void testSortingOnEmbeddedString() {
        this.storeTestingData(new Person(0, (Integer)3, "Three", new CuddlyToy("Hippo")), new Person(1, (Integer)10, "Ten", new CuddlyToy("Giraffe")), new Person(2, (Integer)9, "Nine", new CuddlyToy("Gorilla")), new Person(3, (Integer)5, "Five", new CuddlyToy("Alligator")));
        Query query = this.factoryHolder.getSearchFactory().buildQueryBuilder().forEntity(Person.class).get().all().createQuery();
        Sort sortAsString = new Sort(new SortField("favoriteCuddlyToy.type", SortField.Type.STRING));
        this.assertSortedResults(query, sortAsString, 3, 1, 2, 0);
    }

    public void testSortOnNullableNumericField() throws Exception {
        this.storeTestingData(new Person(1, (Integer)25, "name1", new Integer[0]), new Person(2, (Integer)22, null, new Integer[0]), new Person(3, null, "name3", new Integer[0]));
        HSQuery nameQuery = this.queryForValueNullAndSorting("name", SortField.Type.STRING);
        Assert.assertEquals((long)nameQuery.queryEntityInfos().size(), (long)1L);
        HSQuery ageQuery = this.queryForValueNullAndSorting("ageForNullChecks", SortField.Type.INT);
        Assert.assertEquals((long)ageQuery.queryEntityInfos().size(), (long)1L);
    }

    @Test
    public void testSortOnNullableNumericFieldArray() throws Exception {
        this.storeTestingData(new Person(1, (Integer)25, "name1", 1, 2, 3), new Person(2, (Integer)22, "name2", 1, null, 3), new Person(3, (Integer)23, "name3", null, null, null));
        Query rangeQuery = this.queryForRangeOnFieldSorted(0, 2, "array");
        Sort sortAsInt = new Sort(new SortField("array", SortField.Type.INT));
        this.assertNumberOfResults(2, rangeQuery, sortAsInt);
    }

    private void assertNumberOfResults(int expectedResultsNumber, Query query, Sort sort) {
        ExtendedSearchIntegrator integrator = this.factoryHolder.getSearchFactory();
        HSQuery hsQuery = integrator.createHSQuery().luceneQuery(query);
        hsQuery.targetedEntities(Arrays.asList(Person.class));
        if (sort != null) {
            hsQuery.sort(sort);
        }
        Assert.assertEquals((long)expectedResultsNumber, (long)hsQuery.queryResultSize());
    }

    private Query queryForRangeOnFieldSorted(int min, int max, String fieldName) {
        ExtendedSearchIntegrator integrator = this.factoryHolder.getSearchFactory();
        QueryBuilder queryBuilder = integrator.buildQueryBuilder().forEntity(Person.class).get();
        return queryBuilder.range().onField(fieldName).from((Object)min).to((Object)max).createQuery();
    }

    private void storeTestingData(Person ... testData) {
        Worker worker = this.factoryHolder.getSearchFactory().getWorker();
        TransactionContextForTest tc = new TransactionContextForTest();
        for (int i = 0; i < testData.length; ++i) {
            Person p = testData[i];
            worker.performWork(new Work((Object)p, (Serializable)Integer.valueOf(p.id), WorkType.INDEX), (TransactionContext)tc);
        }
        tc.end();
    }

    private void assertSortedResults(Query query, Sort sort, int ... expectedIds) {
        ExtendedSearchIntegrator integrator = this.factoryHolder.getSearchFactory();
        HSQuery hsQuery = integrator.createHSQuery().luceneQuery(query);
        hsQuery.targetedEntities(Arrays.asList(Person.class));
        if (sort != null) {
            hsQuery.sort(sort);
        }
        Assert.assertEquals((long)expectedIds.length, (long)hsQuery.queryResultSize());
        List queryEntityInfos = hsQuery.queryEntityInfos();
        Assert.assertEquals((long)expectedIds.length, (long)queryEntityInfos.size());
        for (int i = 0; i < expectedIds.length; ++i) {
            EntityInfo entityInfo = (EntityInfo)queryEntityInfos.get(i);
            Assert.assertNotNull((Object)entityInfo);
            Assert.assertEquals((Object)expectedIds[i], (Object)entityInfo.getId());
        }
    }

    private HSQuery queryForValueNullAndSorting(String fieldName, SortField.Type sortType) {
        ExtendedSearchIntegrator integrator = this.factoryHolder.getSearchFactory();
        QueryBuilder queryBuilder = integrator.buildQueryBuilder().forEntity(Person.class).get();
        Query query = queryBuilder.keyword().onField(fieldName).matching(null).createQuery();
        HSQuery hsQuery = integrator.createHSQuery().luceneQuery(query);
        Sort sort = new Sort(new SortField(fieldName, sortType));
        hsQuery.targetedEntities(Arrays.asList(Person.class)).sort(sort);
        return hsQuery;
    }

    private class CuddlyToy {
        @SortableField
        @Field(store=Store.YES, analyze=Analyze.NO, indexNullAs="__DEFAULT_NULL_TOKEN__")
        String type;

        public CuddlyToy(String type) {
            this.type = type;
        }
    }

    @Indexed
    private class Person {
        @DocumentId
        final int id;
        @SortableFields(value={@SortableField(forField="ageForStringSorting"), @SortableField(forField="ageForIntSorting")})
        @Fields(value={@Field(name="ageForStringSorting", store=Store.YES, analyze=Analyze.NO, bridge=@FieldBridge(impl=IntegerBridge.class)), @Field(name="ageForIntSorting", store=Store.YES, analyze=Analyze.NO), @Field(name="ageForNullChecks", store=Store.YES, analyze=Analyze.NO, indexNullAs="-1")})
        final Integer age;
        @SortableField
        @Field(store=Store.YES, analyze=Analyze.NO, indexNullAs="__DEFAULT_NULL_TOKEN__")
        final String name;
        @IndexedEmbedded
        final CuddlyToy favoriteCuddlyToy;
        @Field
        @IndexedEmbedded
        Integer[] array;

        Person(int id, Integer age, String name, CuddlyToy favoriteCuddlyToy) {
            this.id = id;
            this.age = age;
            this.name = name;
            this.favoriteCuddlyToy = favoriteCuddlyToy;
        }

        Person(int id, Integer age, String name, Integer ... arrayItems) {
            this.id = id;
            this.age = age;
            this.name = name;
            this.array = arrayItems;
            this.favoriteCuddlyToy = null;
        }
    }
}

