/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.testsupport;

import java.io.File;
import java.net.URL;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.analysis.core.SimpleAnalyzer;
import org.apache.lucene.analysis.core.StopAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.util.Version;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public final class TestConstants {
    public static final Analyzer standardAnalyzer = new StandardAnalyzer();
    public static final Analyzer stopAnalyzer = new StopAnalyzer();
    public static final Analyzer simpleAnalyzer = new SimpleAnalyzer();
    public static final Analyzer keywordAnalyzer = new KeywordAnalyzer();
    private static final Log log = LoggerFactory.make();

    private TestConstants() {
    }

    public static Version getTargetLuceneVersion() {
        return Version.LATEST;
    }

    public static File getTargetDir(Class<?> testClass) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        String currentTestClass = testClass.getName();
        int hopsToCompileDirectory = currentTestClass.split("\\.").length;
        int hopsToTargetDirectory = hopsToCompileDirectory + 1;
        URL classURL = contextClassLoader.getResource(currentTestClass.replace('.', '/') + ".class");
        File targetDir = new File(classURL.getFile());
        for (int i = 0; i < hopsToTargetDirectory; ++i) {
            targetDir = targetDir.getParentFile();
        }
        return targetDir;
    }

    public static String getIndexDirectory(Class<?> testClass) {
        File targetDir = TestConstants.getTargetDir(testClass);
        String indexDirPath = targetDir.getAbsolutePath() + File.separator + "indextemp";
        log.debugf("Using %s as index directory.", (Object)indexDirPath);
        return indexDirPath;
    }

    public static boolean arePerformanceTestsEnabled() {
        return Boolean.getBoolean("org.hibernate.search.enable_performance_tests");
    }
}

