/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.bridge.impl;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.builtin.impl.TwoWayString2FieldBridgeAdaptor;
import org.hibernate.search.bridge.builtin.time.impl.DurationBridge;
import org.hibernate.search.bridge.builtin.time.impl.InstantBridge;
import org.hibernate.search.bridge.builtin.time.impl.LocalDateBridge;
import org.hibernate.search.bridge.builtin.time.impl.LocalDateTimeBridge;
import org.hibernate.search.bridge.builtin.time.impl.LocalTimeBridge;
import org.hibernate.search.bridge.builtin.time.impl.MonthDayBridge;
import org.hibernate.search.bridge.builtin.time.impl.OffsetDateTimeBridge;
import org.hibernate.search.bridge.builtin.time.impl.OffsetTimeBridge;
import org.hibernate.search.bridge.builtin.time.impl.PeriodBridge;
import org.hibernate.search.bridge.builtin.time.impl.YearBridge;
import org.hibernate.search.bridge.builtin.time.impl.YearMonthBridge;
import org.hibernate.search.bridge.builtin.time.impl.ZoneIdBridge;
import org.hibernate.search.bridge.builtin.time.impl.ZoneOffsetBridge;
import org.hibernate.search.bridge.builtin.time.impl.ZonedDateTimeBridge;
import org.hibernate.search.bridge.spi.BridgeProvider;
import org.hibernate.search.engine.service.classloading.spi.ClassLoaderService;
import org.hibernate.search.engine.service.classloading.spi.ClassLoadingException;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

class JavaTimeBridgeProvider
implements BridgeProvider {
    private static final Log LOG = LoggerFactory.make();
    private final Map<String, FieldBridge> builtInBridges;

    JavaTimeBridgeProvider(ClassLoaderService classLoaderService) {
        Map<String, FieldBridge> bridges = JavaTimeBridgeProvider.populateBridgeMap(classLoaderService);
        this.builtInBridges = bridges;
    }

    private static Map<String, FieldBridge> populateBridgeMap(ClassLoaderService classLoaderService) {
        Map<String, FieldBridge> bridges = new HashMap<String, FieldBridge>(12);
        if (JavaTimeBridgeProvider.classExists(classLoaderService, "java.time.Year")) {
            bridges.put(Year.class.getName(), YearBridge.INSTANCE);
        }
        if (JavaTimeBridgeProvider.classExists(classLoaderService, "java.time.YearMonth")) {
            bridges.put(YearMonth.class.getName(), new TwoWayString2FieldBridgeAdaptor(YearMonthBridge.INSTANCE));
        }
        if (JavaTimeBridgeProvider.classExists(classLoaderService, "java.time.MonthDay")) {
            bridges.put(MonthDay.class.getName(), new TwoWayString2FieldBridgeAdaptor(MonthDayBridge.INSTANCE));
        }
        if (JavaTimeBridgeProvider.classExists(classLoaderService, "java.time.LocalDateTime")) {
            bridges.put(LocalDateTime.class.getName(), new TwoWayString2FieldBridgeAdaptor(LocalDateTimeBridge.INSTANCE));
        }
        if (JavaTimeBridgeProvider.classExists(classLoaderService, "java.time.LocalDate")) {
            bridges.put(LocalDate.class.getName(), new TwoWayString2FieldBridgeAdaptor(LocalDateBridge.INSTANCE));
        }
        if (JavaTimeBridgeProvider.classExists(classLoaderService, "java.time.LocalTime")) {
            bridges.put(LocalTime.class.getName(), new TwoWayString2FieldBridgeAdaptor(LocalTimeBridge.INSTANCE));
        }
        if (JavaTimeBridgeProvider.classExists(classLoaderService, "java.time.OffsetDateTime")) {
            bridges.put(OffsetDateTime.class.getName(), new TwoWayString2FieldBridgeAdaptor(OffsetDateTimeBridge.INSTANCE));
        }
        if (JavaTimeBridgeProvider.classExists(classLoaderService, "java.time.OffsetTime")) {
            bridges.put(OffsetTime.class.getName(), new TwoWayString2FieldBridgeAdaptor(OffsetTimeBridge.INSTANCE));
        }
        if (JavaTimeBridgeProvider.classExists(classLoaderService, "java.time.ZonedDateTime")) {
            bridges.put(ZonedDateTime.class.getName(), new TwoWayString2FieldBridgeAdaptor(ZonedDateTimeBridge.INSTANCE));
        }
        if (JavaTimeBridgeProvider.classExists(classLoaderService, "java.time.ZoneOffset")) {
            bridges.put(ZoneOffset.class.getName(), new TwoWayString2FieldBridgeAdaptor(ZoneOffsetBridge.INSTANCE));
        }
        if (JavaTimeBridgeProvider.classExists(classLoaderService, "java.time.ZoneId")) {
            bridges.put(ZoneId.class.getName(), new TwoWayString2FieldBridgeAdaptor(ZoneIdBridge.INSTANCE));
        }
        if (JavaTimeBridgeProvider.classExists(classLoaderService, "java.time.Period")) {
            bridges.put(Period.class.getName(), new TwoWayString2FieldBridgeAdaptor(PeriodBridge.INSTANCE));
        }
        if (JavaTimeBridgeProvider.classExists(classLoaderService, "java.time.Duration")) {
            bridges.put(Duration.class.getName(), DurationBridge.INSTANCE);
        }
        if (JavaTimeBridgeProvider.classExists(classLoaderService, "java.time.Instant")) {
            bridges.put(Instant.class.getName(), InstantBridge.INSTANCE);
        }
        if (bridges.isEmpty()) {
            bridges = Collections.emptyMap();
        }
        return bridges;
    }

    public boolean hasFoundSomeJavaTimeTypes() {
        return !this.builtInBridges.isEmpty();
    }

    private static boolean classExists(ClassLoaderService classLoaderService, String className) {
        try {
            classLoaderService.classForName(className);
            return true;
        }
        catch (ClassLoadingException e) {
            LOG.javaTimeBridgeWontBeAdded(className);
            return false;
        }
    }

    @Override
    public FieldBridge provideFieldBridge(BridgeProvider.BridgeProviderContext bridgeProviderContext) {
        return this.builtInBridges.get(bridgeProviderContext.getReturnType().getName());
    }
}

