/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.reader.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.uninverting.UninvertingReader;
import org.hibernate.search.engine.metadata.impl.SortableFieldMetadata;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.indexes.spi.ReaderProvider;
import org.hibernate.search.util.StringHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class ManagedMultiReader
extends MultiReader {
    private static final Log log = LoggerFactory.make();
    final IndexReader[] readersForClosing;
    final ReaderProvider[] readerProviders;

    private ManagedMultiReader(IndexReader[] subReaders, IndexReader[] readersForClosing, ReaderProvider[] readerProviders) throws IOException {
        super(subReaders, true);
        assert (readersForClosing.length == readerProviders.length);
        this.readersForClosing = readersForClosing;
        this.readerProviders = readerProviders;
    }

    static ManagedMultiReader createInstance(IndexManager[] indexManagers, Iterable<SortableFieldMetadata> configuredSortableFields, Sort sort) throws IOException {
        int length = indexManagers.length;
        IndexReader[] subReaders = new IndexReader[length];
        ReaderProvider[] readerProviders = new ReaderProvider[length];
        for (int index = 0; index < length; ++index) {
            IndexReader openIndexReader;
            ReaderProvider indexReaderManager = indexManagers[index].getReaderProvider();
            subReaders[index] = openIndexReader = indexReaderManager.openIndexReader();
            readerProviders[index] = indexReaderManager;
        }
        IndexReader[] effectiveReaders = ManagedMultiReader.getEffectiveReaders(indexManagers, subReaders, configuredSortableFields, sort);
        return new ManagedMultiReader(effectiveReaders, subReaders, readerProviders);
    }

    private static IndexReader[] getEffectiveReaders(IndexManager[] indexManagers, IndexReader[] subReaders, Iterable<SortableFieldMetadata> configuredSortFields, Sort sort) {
        if (sort == null || sort.getSort().length == 0) {
            return subReaders;
        }
        IndexReader[] uninvertingReaders = new IndexReader[subReaders.length];
        List<String> uncoveredSorts = ManagedMultiReader.getUncoveredSorts(configuredSortFields, sort);
        if (uncoveredSorts.isEmpty()) {
            return subReaders;
        }
        ArrayList<String> indexNames = new ArrayList<String>();
        for (IndexManager indexManager : indexManagers) {
            indexNames.add(indexManager.getIndexName());
        }
        log.uncoveredSortsRequested(StringHelper.join(indexNames, ", "), StringHelper.join(uncoveredSorts, ", "));
        Map<String, UninvertingReader.Type> mappings = ManagedMultiReader.getMappings(sort);
        int i = 0;
        for (IndexReader reader : subReaders) {
            if (reader instanceof DirectoryReader) {
                DirectoryReader directoryReader = (DirectoryReader)reader;
                try {
                    uninvertingReaders[i] = UninvertingReader.wrap((DirectoryReader)directoryReader, mappings);
                }
                catch (IOException e) {
                    throw log.couldNotCreateUninvertingReader(directoryReader, e);
                }
            } else {
                log.readerTypeUnsupportedForInverting(reader.getClass());
                uninvertingReaders[i] = reader;
            }
            ++i;
        }
        return uninvertingReaders;
    }

    private static List<String> getUncoveredSorts(Iterable<SortableFieldMetadata> configuredSortFields, Sort sort) {
        ArrayList<String> uncoveredSorts = new ArrayList<String>();
        for (SortField sortField : sort.getSort()) {
            if (sortField.getType() == SortField.Type.DOC && sortField.getType() == SortField.Type.SCORE) continue;
            boolean isConfigured = false;
            for (SortableFieldMetadata sortFieldMetadata : configuredSortFields) {
                if (!sortFieldMetadata.getFieldName().equals(sortField.getField())) continue;
                isConfigured = true;
                break;
            }
            if (isConfigured) continue;
            uncoveredSorts.add(sortField.getField());
        }
        return uncoveredSorts;
    }

    private static Map<String, UninvertingReader.Type> getMappings(Sort sort) {
        HashMap<String, UninvertingReader.Type> mappings = new HashMap<String, UninvertingReader.Type>();
        block9: for (SortField sortField : sort.getSort()) {
            if (sortField.getField() == null) continue;
            switch (sortField.getType()) {
                case INT: {
                    mappings.put(sortField.getField(), UninvertingReader.Type.INTEGER);
                    continue block9;
                }
                case LONG: {
                    mappings.put(sortField.getField(), UninvertingReader.Type.LONG);
                    continue block9;
                }
                case FLOAT: {
                    mappings.put(sortField.getField(), UninvertingReader.Type.FLOAT);
                    continue block9;
                }
                case DOUBLE: {
                    mappings.put(sortField.getField(), UninvertingReader.Type.DOUBLE);
                    continue block9;
                }
                case STRING: 
                case STRING_VAL: {
                    mappings.put(sortField.getField(), UninvertingReader.Type.SORTED);
                    continue block9;
                }
                case BYTES: {
                    mappings.put(sortField.getField(), UninvertingReader.Type.BINARY);
                    continue block9;
                }
                case CUSTOM: {
                    continue block9;
                }
                default: {
                    log.sortFieldTypeUnsupported(sortField.getField(), sortField.getType());
                }
            }
        }
        return mappings;
    }

    protected synchronized void doClose() throws IOException {
        boolean debugEnabled = log.isDebugEnabled();
        if (debugEnabled) {
            log.debugf("Closing MultiReader: %s", (Object)this);
        }
        for (int i = 0; i < this.readersForClosing.length; ++i) {
            ReaderProvider container = this.readerProviders[i];
            container.closeIndexReader(this.readersForClosing[i]);
        }
        if (debugEnabled) {
            log.trace("MultiReader closed.");
        }
    }

    public String toString() {
        return ManagedMultiReader.class.getSimpleName() + " [readersForClosing=" + Arrays.toString(this.readersForClosing) + ", readerProviders=" + Arrays.toString(this.readerProviders) + "]";
    }
}

