/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration.indexedembedded;

import java.util.List;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.spi.SearchIntegratorBuilder;
import org.hibernate.search.testsupport.BytemanHelper;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.jboss.byteman.contrib.bmunit.BMRule;
import org.jboss.byteman.contrib.bmunit.BMUnitRunner;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@TestForIssue(jiraKey="HSEARCH-1312")
@RunWith(value=BMUnitRunner.class)
public class IndexedEmbeddedWithAbstractClassTest {
    @Test
    @BMRule(targetClass="org.hibernate.search.util.logging.impl.Log_$logger", targetMethod="abstractClassesCannotInsertDocuments", helper="org.hibernate.search.testsupport.BytemanHelper", action="countInvocation()", name="testAbstractClassAnnotatedWithIndexedLogsWarning")
    public void testAbstractClassAnnotatedWithIndexedLogsWarning() {
        SearchConfigurationForTest configuration = new SearchConfigurationForTest().addClass(A.class).addClass(AbstractA.class).addClass(D.class);
        SearchIntegrator searchIntegrator = new SearchIntegratorBuilder().configuration((SearchConfiguration)configuration).buildSearchIntegrator();
        searchIntegrator.close();
        Assert.assertEquals((String)"Wrong invocation count", (long)1L, (long)BytemanHelper.getAndResetInvocationCount());
    }

    @Test
    @BMRule(targetClass="org.hibernate.search.util.logging.impl.Log_$logger", targetMethod="abstractClassesCannotInsertDocuments", helper="org.hibernate.search.testsupport.BytemanHelper", action="countInvocation()", name="testAbstractClassAnnotatedWithIndexedLogsWarning")
    public void testInvalidConfiguredPathThrowsException() {
        try {
            SearchConfigurationForTest configuration = new SearchConfigurationForTest().addClass(B.class).addClass(AbstractB.class).addClass(D.class);
            new SearchIntegratorBuilder().configuration((SearchConfiguration)configuration).buildSearchIntegrator();
            Assert.fail((String)"Invalid configuration should throw an exception");
        }
        catch (SearchException e) {
            Assert.assertTrue((String)"Invalid exception code", (boolean)e.getMessage().startsWith("HSEARCH000216"));
        }
        Assert.assertEquals((String)"Wrong invocation count", (long)0L, (long)BytemanHelper.getAndResetInvocationCount());
    }

    @Test
    @BMRule(targetClass="org.hibernate.search.util.logging.impl.Log_$logger", targetMethod="abstractClassesCannotInsertDocuments", helper="org.hibernate.search.testsupport.BytemanHelper", action="countInvocation()", name="testAbstractClassAnnotatedWithIndexedLogsWarning")
    public void testInvalidConfiguredPathThrowsExceptionAndIndexedAbstractClassLogsWarning() {
        try {
            SearchConfigurationForTest configuration = new SearchConfigurationForTest().addClass(C.class).addClass(AbstractC.class).addClass(D.class);
            new SearchIntegratorBuilder().configuration((SearchConfiguration)configuration).buildSearchIntegrator();
            Assert.fail((String)"Invalid configuration should throw an exception");
        }
        catch (SearchException e) {
            Assert.assertTrue((String)"Invalid exception code", (boolean)e.getMessage().startsWith("HSEARCH000216"));
        }
        Assert.assertEquals((String)"Wrong invocation count", (long)1L, (long)BytemanHelper.getAndResetInvocationCount());
    }

    @Indexed
    public static class D {
        @DocumentId
        long id;
        @Field
        String foo;
    }

    @Indexed
    public static final class C
    extends AbstractC {
    }

    @Indexed
    public static abstract class AbstractC {
        @DocumentId
        long id;
        @IndexedEmbedded(includePaths={"snafu", "fubar"})
        List<D> list;
    }

    @Indexed
    public static final class B
    extends AbstractB {
    }

    public static abstract class AbstractB {
        @DocumentId
        long id;
        @IndexedEmbedded(includePaths={"snafu", "fubar"})
        List<D> list;
    }

    @Indexed
    public static final class A
    extends AbstractA {
    }

    @Indexed
    public static abstract class AbstractA {
        @DocumentId
        long id;
        @IndexedEmbedded(includePaths={"foo"})
        List<D> list;
    }
}

