/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.jmx;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Properties;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.testsupport.TestConstants;

class SimpleJNDIHelper {
    private SimpleJNDIHelper() {
    }

    public static Path makeTestingJndiDirectory(Class<?> testClass) {
        Path targetDir = TestConstants.getTargetDir(testClass);
        Path simpleJndiDir = targetDir.resolve("simpleJndi");
        if (!Files.exists(simpleJndiDir, new LinkOption[0])) {
            try {
                Files.createDirectory(simpleJndiDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return simpleJndiDir;
    }

    public static void enableSimpleJndi(SearchConfiguration configuration, Path jndiStorage) {
        Properties p = configuration.getProperties();
        SimpleJNDIHelper.enableSimpleJndi(p, jndiStorage);
    }

    public static void enableSimpleJndi(Map p, Path jndiStorage) {
        p.put("hibernate.jndi.class", "org.osjava.sj.SimpleContextFactory");
        p.put("hibernate.jndi.org.osjava.sj.root", jndiStorage.toAbsolutePath().toString());
        p.put("hibernate.jndi.org.osjava.sj.jndi.shared", "true");
    }
}

