/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.testsupport;

import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicInteger;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.helper.Helper;
import org.junit.Assert;

public class BytemanHelper
extends Helper {
    private static final Log log = LoggerFactory.make();
    private static final AtomicInteger counter = new AtomicInteger();
    private static final Deque<String> concurrentStack = new ConcurrentLinkedDeque<String>();

    protected BytemanHelper(Rule rule) {
        super(rule);
    }

    public void sleepASecond() {
        try {
            log.info((Object)"Byteman rule triggered: sleeping a second");
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error((Object)"unexpected interruption", (Throwable)e);
        }
    }

    public void assertBooleanValue(boolean actual, boolean expected) {
        if (actual != expected) {
            Assert.fail((String)"Unexpected boolean value");
        }
    }

    public void countInvocation() {
        log.debug((Object)"Increment call count");
        counter.incrementAndGet();
    }

    public static int getAndResetInvocationCount() {
        return counter.getAndSet(0);
    }

    public void pushEvent(String message) {
        concurrentStack.add(message);
    }

    public static String consumeNextRecordedEvent() {
        return concurrentStack.removeFirst();
    }

    public static boolean isEventStackEmpty() {
        return concurrentStack.isEmpty();
    }

    static void resetEventStack() {
        concurrentStack.clear();
    }
}

