/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.testsupport;

import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.analysis.core.SimpleAnalyzer;
import org.apache.lucene.analysis.core.StopAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.util.Version;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public final class TestConstants {
    public static final Analyzer standardAnalyzer = new StandardAnalyzer();
    public static final Analyzer stopAnalyzer = new StopAnalyzer();
    public static final Analyzer simpleAnalyzer = new SimpleAnalyzer();
    public static final Analyzer keywordAnalyzer = new KeywordAnalyzer();
    private static final Log log = LoggerFactory.make();

    private TestConstants() {
    }

    public static Version getTargetLuceneVersion() {
        return Version.LATEST;
    }

    public static Path getTargetDir(Class<?> testClass) {
        Path targetDir;
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        String currentTestClass = testClass.getName();
        int hopsToCompileDirectory = currentTestClass.split("\\.").length;
        int hopsToTargetDirectory = hopsToCompileDirectory + 1;
        URL classURL = contextClassLoader.getResource(currentTestClass.replace('.', '/') + ".class");
        try {
            targetDir = Paths.get(classURL.toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        for (int i = 0; i < hopsToTargetDirectory; ++i) {
            targetDir = targetDir.getParent();
        }
        return targetDir;
    }

    public static String getIndexDirectory(Class<?> testClass) {
        Path targetDir = TestConstants.getTargetDir(testClass);
        Path indexDirPath = targetDir.resolve("indextemp");
        String indexDir = indexDirPath.toAbsolutePath().toString();
        log.debugf("Using %s as index directory.", (Object)indexDir);
        return indexDir;
    }

    public static boolean arePerformanceTestsEnabled() {
        return Boolean.getBoolean("org.hibernate.search.enable_performance_tests");
    }
}

