/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.testsupport.backend;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.impl.lucene.LuceneBackendQueueProcessor;
import org.hibernate.search.backend.spi.BackendQueueProcessor;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.util.impl.ClassLoaderHelper;

public class LeakingBackendQueueProcessor
implements BackendQueueProcessor {
    private static final String ES_INDEX_MANAGER = "org.hibernate.search.backend.elasticsearch.impl.ElasticsearchIndexManager";
    private static final String ES_BACKEND_QUEUE_PROCESSOR = "org.hibernate.search.backend.elasticsearch.impl.ElasticsearchBackendQueueProcessor";
    private static volatile List<LuceneWork> lastProcessedQueue = new ArrayList<LuceneWork>();
    private BackendQueueProcessor delegate;

    public void initialize(Properties props, WorkerBuildContext context, IndexManager indexManager) {
        this.delegate = ES_INDEX_MANAGER.equals(indexManager.getClass().getName()) ? (BackendQueueProcessor)ClassLoaderHelper.instanceFromName(BackendQueueProcessor.class, (String)ES_BACKEND_QUEUE_PROCESSOR, (String)"Elasticsearch backend", (ServiceManager)context.getServiceManager()) : new LuceneBackendQueueProcessor();
        this.delegate.initialize(props, context, indexManager);
    }

    public void close() {
        lastProcessedQueue = new ArrayList<LuceneWork>();
        this.delegate.close();
    }

    public void applyWork(List<LuceneWork> workList, IndexingMonitor monitor) {
        this.delegate.applyWork(workList, monitor);
        lastProcessedQueue = workList;
    }

    public void applyStreamWork(LuceneWork singleOperation, IndexingMonitor monitor) {
        this.delegate.applyStreamWork(singleOperation, monitor);
    }

    public Lock getExclusiveWriteLock() {
        return this.delegate.getExclusiveWriteLock();
    }

    public void indexMappingChanged() {
        this.delegate.indexMappingChanged();
    }

    public static List<LuceneWork> getLastProcessedQueue() {
        return lastProcessedQueue;
    }

    public static void reset() {
        lastProcessedQueue = new ArrayList<LuceneWork>();
    }

    public void flushAndReleaseResources() {
        this.delegate.flushAndReleaseResources();
    }
}

