/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.backend.lucene;

import java.io.Serializable;
import java.util.Collections;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.backend.spi.WorkType;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.hibernate.search.test.backend.lucene.Quote;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.setup.TransactionContextForTest;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class AsyncBackendFlushTest {
    private static final int ENTITIES = 100;
    @Rule
    public SearchFactoryHolder sfHolder = new SearchFactoryHolder(Quote.class).withProperty("hibernate.search.default.worker.execution", "async");

    @Test
    public void testFlush() throws Exception {
        this.writeData(this.sfHolder, 0, 50);
        this.flushIndex();
        this.assertDocumentsIndexed(50);
        this.writeData(this.sfHolder, 50, 100);
        this.flushIndex();
        this.assertDocumentsIndexed(100);
    }

    private void flushIndex() {
        this.sfHolder.extractIndexManager(Quote.class).flushAndReleaseResources();
    }

    private void assertDocumentsIndexed(int number) {
        ExtendedSearchIntegrator searchFactory = this.sfHolder.getSearchFactory();
        HSQuery hsQuery = searchFactory.createHSQuery().luceneQuery((Query)new MatchAllDocsQuery()).targetedEntities(Collections.singletonList(Quote.class));
        Assert.assertEquals((long)number, (long)hsQuery.queryResultSize());
    }

    private void writeData(SearchFactoryHolder sfHolder, int fromId, int toId) {
        for (int i = fromId; i < toId; ++i) {
            Quote quote = new Quote(i, Quote.class.getName());
            Work work = new Work((Object)quote, (Serializable)Integer.valueOf(i), WorkType.ADD, false);
            TransactionContextForTest tc = new TransactionContextForTest();
            sfHolder.getSearchFactory().getWorker().performWork(work, (TransactionContext)tc);
            tc.end();
        }
    }
}

