/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.serialization;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.search.Query;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.backend.spi.WorkType;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.serialization.SerializationTestHelper;
import org.hibernate.search.testsupport.setup.TransactionContextForTest;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class QuerySerializationTest {
    @Rule
    public SearchFactoryHolder sfHolder = new SearchFactoryHolder(Book.class);

    @Test
    public void verifyExceptionOnNonMeaningfullQueries() throws ClassNotFoundException, IOException {
        ExtendedSearchIntegrator integrator = this.sfHolder.getSearchFactory();
        Book book = new Book();
        book.title = "Java Serialization";
        book.text = "The black art of object serialization is full of pitfalls even for experienced developers";
        Work work = new Work((Object)book, (Serializable)((Object)book.title), WorkType.ADD, false);
        TransactionContextForTest tc = new TransactionContextForTest();
        integrator.getWorker().performWork(work, (TransactionContext)tc);
        tc.end();
        QueryBuilder queryBuilder = integrator.buildQueryBuilder().forEntity(Book.class).get();
        Query luceneQuery = queryBuilder.keyword().onField("text").matching((Object)"art").createQuery();
        HSQuery hsQuery = integrator.createHSQuery().luceneQuery(luceneQuery);
        hsQuery.targetedEntities(Arrays.asList(Book.class));
        hsQuery.luceneQuery(null);
        HSQuery clonedQuery = SerializationTestHelper.duplicateBySerialization(hsQuery);
        clonedQuery.afterDeserialise((SearchIntegrator)integrator);
        clonedQuery.luceneQuery(luceneQuery);
        List result = clonedQuery.queryEntityInfos();
        Assert.assertEquals((long)1L, (long)result.size());
    }

    @Indexed
    static class Book {
        @DocumentId
        String title;
        @Field
        String text;

        Book() {
        }
    }
}

