/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.impl;

import java.beans.Introspector;
import java.io.IOException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.util.Version;
import org.hibernate.annotations.common.reflection.XAnnotatedElement;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XMember;
import org.hibernate.annotations.common.reflection.XPackage;
import org.hibernate.search.analyzer.impl.AnalyzerReference;
import org.hibernate.search.analyzer.impl.LazyLuceneAnalyzer;
import org.hibernate.search.analyzer.impl.LazyRemoteAnalyzer;
import org.hibernate.search.analyzer.impl.LuceneAnalyzerReference;
import org.hibernate.search.analyzer.impl.RemoteAnalyzer;
import org.hibernate.search.analyzer.impl.RemoteAnalyzerProvider;
import org.hibernate.search.analyzer.impl.RemoteAnalyzerReference;
import org.hibernate.search.annotations.AnalyzerDef;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.Factory;
import org.hibernate.search.annotations.FullTextFilterDef;
import org.hibernate.search.annotations.Key;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.cfg.EntityDescriptor;
import org.hibernate.search.cfg.Environment;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.impl.FilterDef;
import org.hibernate.search.engine.impl.SolrAnalyzerBuilder;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.filter.ShardSensitiveOnlyFilter;
import org.hibernate.search.indexes.impl.IndexManagerHolder;
import org.hibernate.search.indexes.spi.IndexManagerType;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.util.StringHelper;
import org.hibernate.search.util.impl.ClassLoaderHelper;
import org.hibernate.search.util.impl.ReflectionHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public final class ConfigContext {
    private static final Log log = LoggerFactory.make();
    private static final String DEFAULT_NULL_INDEX_TOKEN = "_null_";
    private static final String PROGRAMMATIC_ANALYZER_DEFINITION = "PROGRAMMATIC_ANALYZER_DEFINITION";
    private static final String PROGRAMMATIC_FILTER_DEFINITION = "PROGRAMMATIC_FILTER_DEFINITION";
    private final Map<String, String> analyzerDefinitionPoints = new HashMap<String, String>();
    private final Map<String, String> filterDefinitionPoints = new HashMap<String, String>();
    private final Map<String, AnalyzerDef> analyzerDefs = new HashMap<String, AnalyzerDef>();
    private final Map<String, FilterDef> filterDefs = new HashMap<String, FilterDef>();
    private final List<LuceneAnalyzerReference> lazyLuceneAnalyzerReferences = new ArrayList<LuceneAnalyzerReference>();
    private final List<RemoteAnalyzerReference> lazyRemoteAnalyzerReferences = new ArrayList<RemoteAnalyzerReference>();
    private final AnalyzerReference defaultLuceneAnalyzerReference;
    private final boolean jpaPresent;
    private final Version luceneMatchVersion;
    private final String nullToken;
    private final boolean implicitProvidedId;
    private final SearchMapping searchMapping;
    private final ServiceManager serviceManager;

    public ConfigContext(SearchConfiguration searchConfiguration, BuildContext buildContext) {
        this(searchConfiguration, buildContext, null);
    }

    public ConfigContext(SearchConfiguration searchConfiguration, BuildContext buildContext, SearchMapping searchMapping) {
        this.serviceManager = buildContext.getServiceManager();
        this.luceneMatchVersion = this.getLuceneMatchVersion(searchConfiguration);
        this.defaultLuceneAnalyzerReference = this.initDefaultLuceneAnalyzerReference(searchConfiguration);
        this.jpaPresent = this.isPresent("javax.persistence.Id");
        this.nullToken = this.initNullToken(searchConfiguration);
        this.implicitProvidedId = searchConfiguration.isIdProvidedImplicit();
        this.searchMapping = searchMapping;
    }

    public ServiceManager getServiceManager() {
        return this.serviceManager;
    }

    public void addAnalyzerDef(AnalyzerDef analyzerDef, XAnnotatedElement annotatedElement) {
        if (analyzerDef == null) {
            return;
        }
        this.addAnalyzerDef(analyzerDef, this.buildAnnotationDefinitionPoint(annotatedElement));
    }

    public void addFullTextFilterDef(FullTextFilterDef filterDef, XAnnotatedElement annotatedElement) {
        if (filterDef == null) {
            return;
        }
        this.addFullTextFilterDef(filterDef, this.buildAnnotationDefinitionPoint(annotatedElement));
    }

    public void addGlobalAnalyzerDef(AnalyzerDef analyzerDef) {
        this.addAnalyzerDef(analyzerDef, PROGRAMMATIC_ANALYZER_DEFINITION);
    }

    public void addGlobalFullTextFilterDef(FullTextFilterDef filterDef) {
        this.addFullTextFilterDef(filterDef, PROGRAMMATIC_FILTER_DEFINITION);
    }

    private void addAnalyzerDef(AnalyzerDef analyzerDef, String annotationDefinitionPoint) {
        String analyzerDefinitionName = analyzerDef.name();
        if (this.analyzerDefinitionPoints.containsKey(analyzerDefinitionName)) {
            if (!this.analyzerDefinitionPoints.get(analyzerDefinitionName).equals(annotationDefinitionPoint)) {
                throw new SearchException("Multiple analyzer definitions with the same name: " + analyzerDef.name());
            }
        } else {
            this.analyzerDefs.put(analyzerDefinitionName, analyzerDef);
            this.analyzerDefinitionPoints.put(analyzerDefinitionName, annotationDefinitionPoint);
        }
    }

    public AnalyzerReference buildLazyLuceneAnalyzerReference(String name) {
        LuceneAnalyzerReference reference = new LuceneAnalyzerReference((Analyzer)new LazyLuceneAnalyzer(name));
        this.lazyLuceneAnalyzerReferences.add(reference);
        return reference;
    }

    public AnalyzerReference buildRemoteAnalyzerReference(String name) {
        RemoteAnalyzerReference reference = new RemoteAnalyzerReference(new LazyRemoteAnalyzer(name));
        this.lazyRemoteAnalyzerReferences.add(reference);
        return reference;
    }

    private AnalyzerReference initDefaultLuceneAnalyzerReference(SearchConfiguration cfg) {
        Class analyzerClass;
        String analyzerClassName = cfg.getProperty("hibernate.search.analyzer");
        if (analyzerClassName != null) {
            try {
                analyzerClass = ClassLoaderHelper.classForName(analyzerClassName, this.serviceManager);
            }
            catch (Exception e) {
                return this.buildLazyLuceneAnalyzerReference(analyzerClassName);
            }
        } else {
            analyzerClass = StandardAnalyzer.class;
        }
        Analyzer analyzer = ClassLoaderHelper.analyzerInstanceFromClass(analyzerClass, this.luceneMatchVersion);
        LuceneAnalyzerReference reference = new LuceneAnalyzerReference(analyzer);
        return reference;
    }

    private String initNullToken(SearchConfiguration cfg) {
        String defaultNullIndexToken = cfg.getProperty("hibernate.search.default_null_token");
        if (StringHelper.isEmpty(defaultNullIndexToken)) {
            defaultNullIndexToken = DEFAULT_NULL_INDEX_TOKEN;
        }
        return defaultNullIndexToken;
    }

    public String getDefaultNullToken() {
        return this.nullToken;
    }

    public AnalyzerReference getDefaultLuceneAnalyzerReference() {
        return this.defaultLuceneAnalyzerReference;
    }

    public Version getLuceneMatchVersion() {
        return this.luceneMatchVersion;
    }

    private void addFullTextFilterDef(FullTextFilterDef filterDef, String filterDefinitionPoint) {
        String filterDefinitionName = filterDef.name();
        if (this.filterDefinitionPoints.containsKey(filterDefinitionName)) {
            if (!this.filterDefinitionPoints.get(filterDefinitionName).equals(filterDefinitionPoint)) {
                throw new SearchException("Multiple filter definitions with the same name: " + filterDef.name());
            }
        } else {
            this.filterDefinitionPoints.put(filterDefinitionName, filterDefinitionPoint);
            this.addFilterDef(filterDef);
        }
    }

    private void addFilterDef(FullTextFilterDef defAnn) {
        FilterDef filterDef = new FilterDef(defAnn);
        if (filterDef.getImpl().equals(ShardSensitiveOnlyFilter.class)) {
            this.filterDefs.put(defAnn.name(), filterDef);
            return;
        }
        try {
            filterDef.getImpl().newInstance();
        }
        catch (IllegalAccessException e) {
            throw new SearchException("Unable to create Filter class: " + filterDef.getImpl().getName(), e);
        }
        catch (InstantiationException e) {
            throw new SearchException("Unable to create Filter class: " + filterDef.getImpl().getName(), e);
        }
        for (Method method : filterDef.getImpl().getMethods()) {
            String name;
            if (method.isAnnotationPresent(Factory.class)) {
                if (filterDef.getFactoryMethod() != null) {
                    throw new SearchException("Multiple @Factory methods found" + defAnn.name() + ": " + filterDef.getImpl().getName() + "." + method.getName());
                }
                ReflectionHelper.setAccessible(method);
                filterDef.setFactoryMethod(method);
            }
            if (method.isAnnotationPresent(Key.class)) {
                if (filterDef.getKeyMethod() != null) {
                    throw new SearchException("Multiple @Key methods found" + defAnn.name() + ": " + filterDef.getImpl().getName() + "." + method.getName());
                }
                ReflectionHelper.setAccessible(method);
                filterDef.setKeyMethod(method);
            }
            if (!(name = method.getName()).startsWith("set") || method.getParameterTypes().length != 1) continue;
            filterDef.addSetter(Introspector.decapitalize(name.substring(3)), method);
        }
        this.filterDefs.put(defAnn.name(), filterDef);
    }

    public Map<String, AnalyzerReference> initLazyAnalyzerReferences(IndexManagerHolder indexesFactory) {
        HashMap<String, AnalyzerReference> initializedAnalyzers = new HashMap<String, AnalyzerReference>(this.analyzerDefs.size());
        for (LuceneAnalyzerReference luceneAnalyzerReference : this.lazyLuceneAnalyzerReferences) {
            this.initLazyLuceneAnalyzer(initializedAnalyzers, luceneAnalyzerReference);
        }
        for (RemoteAnalyzerReference remoteAnalyzerReference : this.lazyRemoteAnalyzerReferences) {
            this.initLazyRemoteAnalyzer(initializedAnalyzers, remoteAnalyzerReference, indexesFactory);
        }
        this.initLazyRemoteAnalyzer(initializedAnalyzers, RemoteAnalyzerReference.DEFAULT, indexesFactory);
        this.initLazyRemoteAnalyzer(initializedAnalyzers, RemoteAnalyzerReference.PASS_THROUGH, indexesFactory);
        for (Map.Entry entry : this.analyzerDefs.entrySet()) {
            if (initializedAnalyzers.containsKey(entry.getKey())) continue;
            Analyzer analyzer = this.buildAnalyzer((AnalyzerDef)entry.getValue());
            LuceneAnalyzerReference reference = new LuceneAnalyzerReference(analyzer);
            initializedAnalyzers.put((String)entry.getKey(), reference);
        }
        return Collections.unmodifiableMap(initializedAnalyzers);
    }

    private void initLazyRemoteAnalyzer(Map<String, AnalyzerReference> initializedAnalyzers, RemoteAnalyzerReference lazyRemoteAnalyzerReference, IndexManagerHolder indexesFactory) {
        LazyRemoteAnalyzer lazyAnalyzer = (LazyRemoteAnalyzer)lazyRemoteAnalyzerReference.getAnalyzer();
        if (initializedAnalyzers.containsKey(lazyAnalyzer.getName())) {
            AnalyzerReference analyzerReference = initializedAnalyzers.get(lazyAnalyzer.getName());
            if (!(analyzerReference instanceof RemoteAnalyzerReference)) {
                throw log.remoteAnalyzerAlreadyDefinedAsLuceneAnalyzer(lazyAnalyzer.getName());
            }
            lazyAnalyzer.setDelegate(((RemoteAnalyzerReference)analyzerReference).getAnalyzer());
            return;
        }
        Collection<IndexManagerType> indexManagerTypes = indexesFactory.getIndexManagerTypes();
        for (IndexManagerType indexManagerType : indexManagerTypes) {
            if (!(indexManagerType instanceof RemoteAnalyzerProvider)) continue;
            RemoteAnalyzer remoteAnalyzer = ((RemoteAnalyzerProvider)((Object)indexManagerType)).getRemoteAnalyzer(lazyAnalyzer.getName());
            lazyAnalyzer.setDelegate(remoteAnalyzer);
            initializedAnalyzers.put(lazyAnalyzer.getName(), new RemoteAnalyzerReference(remoteAnalyzer));
            break;
        }
    }

    private void initLazyLuceneAnalyzer(Map<String, AnalyzerReference> initializedAnalyzers, LuceneAnalyzerReference lazyLuceneAnalyzerReference) {
        LazyLuceneAnalyzer lazyAnalyzer = (LazyLuceneAnalyzer)lazyLuceneAnalyzerReference.getAnalyzer();
        if (initializedAnalyzers.containsKey(lazyAnalyzer.getName())) {
            lazyAnalyzer.setDelegate(((LuceneAnalyzerReference)initializedAnalyzers.get(lazyAnalyzer.getName())).getAnalyzer());
            return;
        }
        if (!this.analyzerDefs.containsKey(lazyAnalyzer.getName())) {
            throw new SearchException("Analyzer found with an unknown definition: " + lazyAnalyzer.getName());
        }
        Analyzer analyzer = this.buildAnalyzer(this.analyzerDefs.get(lazyAnalyzer.getName()));
        lazyAnalyzer.setDelegate(analyzer);
        initializedAnalyzers.put(lazyAnalyzer.getName(), new LuceneAnalyzerReference(analyzer));
    }

    public Map<String, FilterDef> initFilters() {
        return Collections.unmodifiableMap(this.filterDefs);
    }

    private Analyzer buildAnalyzer(AnalyzerDef analyzerDef) {
        try {
            return SolrAnalyzerBuilder.buildAnalyzer(analyzerDef, this.luceneMatchVersion, this.serviceManager);
        }
        catch (IOException e) {
            throw new SearchException("Could not initialize Analyzer definition " + analyzerDef, e);
        }
    }

    public boolean isJpaPresent() {
        return this.jpaPresent;
    }

    private boolean isPresent(String className) {
        try {
            ClassLoaderHelper.classForName(className, this.serviceManager);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private Version getLuceneMatchVersion(SearchConfiguration cfg) {
        Version version;
        String tmp = cfg.getProperty("hibernate.search.lucene_version");
        if (StringHelper.isEmpty(tmp)) {
            log.recommendConfiguringLuceneVersion();
            version = Environment.DEFAULT_LUCENE_MATCH_VERSION;
        } else {
            try {
                version = Version.parseLeniently((String)tmp);
                if (log.isDebugEnabled()) {
                    log.debug("Setting Lucene compatibility to Version " + version);
                }
            }
            catch (IllegalArgumentException e) {
                throw log.illegalLuceneVersionFormat(tmp, e.getMessage());
            }
            catch (ParseException e) {
                throw log.illegalLuceneVersionFormat(tmp, e.getMessage());
            }
        }
        return version;
    }

    private String buildAnnotationDefinitionPoint(XAnnotatedElement annotatedElement) {
        if (annotatedElement instanceof XClass) {
            return ((XClass)annotatedElement).getName();
        }
        if (annotatedElement instanceof XMember) {
            XMember member = (XMember)annotatedElement;
            return member.getType().getName() + '.' + member.getName();
        }
        if (annotatedElement instanceof XPackage) {
            return ((XPackage)annotatedElement).getName();
        }
        throw new SearchException("Unknown XAnnotatedElement: " + annotatedElement);
    }

    public boolean isProvidedIdImplicit() {
        return this.implicitProvidedId;
    }

    public Map<FieldBridge, ClassBridge> getClassBridgeInstances(Class<?> type) {
        EntityDescriptor entityDescriptor;
        Map<FieldBridge, ClassBridge> classBridgeInstances = null;
        if (this.searchMapping != null && (entityDescriptor = this.searchMapping.getEntityDescriptor(type)) != null) {
            classBridgeInstances = entityDescriptor.getClassBridgeConfigurations();
        }
        return classBridgeInstances != null ? classBridgeInstances : Collections.emptyMap();
    }
}

