/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.metadata.impl;

import java.util.LinkedHashSet;
import java.util.Set;
import org.hibernate.search.bridge.spi.FieldMetadataBuilder;
import org.hibernate.search.bridge.spi.FieldMetadataCreationContext;
import org.hibernate.search.bridge.spi.FieldType;
import org.hibernate.search.engine.metadata.impl.BackReference;
import org.hibernate.search.engine.metadata.impl.BridgeDefinedField;
import org.hibernate.search.engine.metadata.impl.DocumentFieldMetadata;

class FieldMetadataBuilderImpl
implements FieldMetadataBuilder {
    private final Set<String> sortableFieldsAbsoluteNames = new LinkedHashSet<String>();
    private final Set<BridgeDefinedField> bridgeDefinedFields = new LinkedHashSet<BridgeDefinedField>();
    private final BackReference<DocumentFieldMetadata> fieldMetadata;

    public FieldMetadataBuilderImpl(BackReference<DocumentFieldMetadata> fieldMetadata) {
        this.fieldMetadata = fieldMetadata;
    }

    @Override
    public FieldMetadataCreationContext field(String name, FieldType type) {
        return new FieldMetadataCreationContextImpl(name, type);
    }

    public Set<String> getSortableFieldsAbsoluteNames() {
        return this.sortableFieldsAbsoluteNames;
    }

    public Set<BridgeDefinedField> getBridgeDefinedFields() {
        return this.bridgeDefinedFields;
    }

    private class FieldMetadataCreationContextImpl
    implements FieldMetadataCreationContext {
        private final String absoluteFieldName;

        public FieldMetadataCreationContextImpl(String name, FieldType type) {
            this.absoluteFieldName = name;
            FieldMetadataBuilderImpl.this.bridgeDefinedFields.add(new BridgeDefinedField(FieldMetadataBuilderImpl.this.fieldMetadata, name, type));
        }

        @Override
        public FieldMetadataCreationContext field(String name, FieldType type) {
            return FieldMetadataBuilderImpl.this.field(name, type);
        }

        @Override
        public FieldMetadataCreationContext sortable(boolean sortable) {
            FieldMetadataBuilderImpl.this.sortableFieldsAbsoluteNames.add(this.absoluteFieldName);
            return this;
        }
    }
}

